package com.rocogz.syy.infrastructure.entity.platformcipher;


import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.VersionEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 平台登录凭证表</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/14 14:56</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@TableName(value = "basic_platform_user_cipher")
public class PlatformUserCipher extends VersionEntity {

    /**
     * 手机号  (唯一)
     */
    private String mobile;

    /**
     * 验证码/随机码
     */
    private String cipher;

    /**
     * 微信openid (唯一)
(通过后更新)
     */
    private String openid;

    /**
     * 姓名
(通过后更新)
     */
    private String name;

    /**
     * 状态:
PENDING:待验证
PASS:验证通过
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 验证通过时间
(通过后更新)
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime checkTime;


    private String nickName;

    /**
     * 所属项目编码
     */
    private String systemCode;
}