package com.rocogz.syy.infrastructure.entity.subscription.entity;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 微信订阅列表
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class BasicWxSubscription extends IdEntity {

    private static final long serialVersionUID = -3719123280492547863L;

    /**
     * 应用id
     */
    private String appid;

    /**
     * 消息模块id
     */
    private String templateId;

    /**
     * 订阅者openid
     */
    private String openid;

    /**
     * 业务代码
     */
    private String businessCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
