package com.rocogz.syy.infrastructure.dto.system.adminuser;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.rocogz.syy.infrastructure.dto.base.PageReq;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * @author djt
 * @date 2021/7/28
 */
@Data
@Accessors(chain = true)
public class AdminServiceUserSearchReq extends PageReq {

    private String mobile;

    private String name;

    private String status;

    private String agentCode;

    private String agentCodes;

    private String roleId;

    private String registerStatus;

    /**
     * 精确匹配手机号
     */
    private String exactMobile;


    public Map<String, Object> toMap() {
        Map<String, Object> map = Maps.newHashMap();
        if (StringUtils.hasLength(this.mobile)) {
            map.put("mobile", "%" + this.mobile + "%");
        }
        if (StringUtils.hasLength(this.exactMobile)) {
            map.put("exactMobile", this.exactMobile);
        }
        if (StringUtils.hasLength(this.name)) {
            map.put("name", "%" + this.name + "%");
        }
        if (StringUtils.hasLength(this.status)) {
            map.put("status", this.status);
        }
        if (StringUtils.hasLength(this.agentCode)) {
            map.put("agentCode", this.agentCode);
        }
        if (StringUtils.hasLength(this.roleId)) {
            map.put("roleId", this.roleId);
        }
        if (StringUtils.hasLength(this.agentCodes)) {
            map.put("agentCodes", Splitter.on(",").splitToList(this.agentCodes));
        }
        if (StringUtils.hasLength(this.registerStatus)){
            map.put("registerStatus",this.registerStatus);
        }
        return map;
    }

}
