package com.rocogz.syy.infrastructure.entity.adminuser;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 车服后台管理用户信息
 * @author djt
 * @date 2021/1/14
 */
@Data
@TableName("basic_admin_user_info")
public class AdminUserInfo  extends IdEntity {

    /**
     * 用户id
     */
    private Integer userId;

    /**
     * 所属平台编号
     */
    private String platformCode;


    /**
     * 平台用户所属平台名称
     */
    @TableField(exist = false)
    private String platformName;



    /**
     * @since 20210207 平台用户改为发放主体用户
     * 发放主体用户的发放主体编号
     */
    private String issuingBodyCode;


    /**
     * @since 20210207 平台用户改为发放主体用户
     * 发放主体用户的发放主体id
     */
    @TableField(exist = false)
    private Integer issuingBodyId;


    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 发放主体账号性质
     */
    private String issuingBodyUserNature;


    /**
     * 发放主体账号类型
     */
    private String  issuingBodyUserType;

    /**
     * 系统账号类型
     */
    private String systemUserType;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 代理商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * <ul>
     *     <li>系统账号数据来源取系统账号配置</li>
     *     <li>发放主体账号数据来源取发放主体配置</li>
     * </ul>
     * 是否可见用户券领取信息
     */
    private String couponReceiveVisible;

    /**
     * 员工号
     */
    private String employeeNo;

    /**
     * 所在部门
     */
    private String department;

    /**
     * 是否需要实名认证
     */
    private Integer authenticationTag;

    /**
     * 是否已经实名认证
     */
    private String authenticationStatus;

    /**
     * 实名认证时间
     */
    private LocalDateTime authenticationTime;


}
