package com.rocogz.syy.infrastructure.entity.log;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 基础服务-用户请求日志
 * </p>
 *
 * @author yinshihao
 * @since 2021-06-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class BasicUserRequestLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 当前请求用户的编号
     */
    private String currentUserCode;

    /**
     * 当前请求用户的openid
     */
    private String currentUserOpenid;

    /**
     * 当前请求用户的手机号
     */
    private String currentUserMobile;

    /**
     * 页面(弹窗)类型  APPLET 本小程序  | H5 H5页面 | ACTIVITY_POP 活动弹窗
     */
    private String pageType;

    /**
     * 页面地址
     */
    private String pageUrl;

    /**
     * 是否主动触发，是: Y,否:N
     */
    private String isAuto;

    /**
     * 点击的按钮名称，主动触发时不传，默认''  TAKE 即刻拿走 | WANT 我要加油券 | CHECK 立即查看 | LEAVE 残忍离开 | CLOSE 关闭按钮
     */
    private String btnName;

    /**
     * 点击时间
     */
    private LocalDateTime clickTime;

    /**
     * 小程序appid
     */
    private String miniAppid;


}
