package com.rocogz.linkcustomerequity.dto.gift;

import com.rocogz.linkcustomerequity.dto.product.Product;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author djt
 * @Description: 代理人标准套餐
 * @date 2020/10/30 11:29
 */
@Data
public class Gift implements Serializable {

    /**
     * 套餐唯一编码（系统生成）
     */
    private String code;
    /**
     * 套餐名称
     */
    private String packageName;
    /**
     * 套餐总市场价
     */
    private BigDecimal faceValue;
    /**
     * 套餐总成本
     */
    private BigDecimal cost;

    /**
     * 结算价
     */
    private BigDecimal settlePrice;
    /**
     * 套餐产品数
     */
    private Integer productTypeCount;

    /**
     * 套餐产品
     */
    private List<GiftProduct> productList;
}
