package com.rocogz.linkcustomerequity.dto.gift;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author zhanghongshan
 * @date 2020/11/6 1:40 下午
 */
@Data
public class GiftReq implements Serializable {
    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 关键字筛选
     */
    private String keyword;

    /**
     * 套餐编码
     */
    private List<String> codes;

    /**
     *  成本价 最小
     */
    private BigDecimal minCostPrice;
    /**
     * 成本价 最大
     */
    private BigDecimal maxCostPrice;

    /**
     * 市场价 最小
     */
    private BigDecimal minMarketPrice;

    /**
     * 市场价 最大
     */
    private BigDecimal maxMarketPrice;

    /**
     * 预算
     */
    private BigDecimal budget;

    /**
     * 市场排序 asc
     */
    private String marketPriceSort;

    /**
     * 成本价排序 desc
     */
    private String costPriceSort;

    /**
     * 页数
     */
    private Integer pageNumber;
    /**
     * 每页显示条数
     */
    private Integer pageSize;

}
