/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.service.config.aop;

import com.alibaba.fastjson.JSON;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
@Aspect
public class ControllerAspect {
    private static Logger logger = LoggerFactory.getLogger(ControllerAspect.class);

    @Around(value="execution(public * com.rocogz..*Controller.*(..))")
    public Object doAroundAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long start = System.nanoTime();
        String clazz = proceedingJoinPoint.getSignature().getDeclaringTypeName();
        String methodName = proceedingJoinPoint.getSignature().getName();
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        logger.info("Class:{}.{} \u8bf7\u6c42url: {}, params: {}", new Object[]{clazz, method, url, queryString});
        Object obj = proceedingJoinPoint.proceed();
        long end = System.nanoTime();
        logger.info("Class: {}.{}.{} \u8bf7\u6c42url: {} \u54cd\u5e94: {}, usedtime: {}ms:", new Object[]{clazz, methodName, method, url, JSON.toJSONString((Object)obj), (end - start) / 1000000L});
        return obj;
    }
}

