/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.service.merchant.label.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.rocogz.merchant.PageTable;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.enumerate.StatusEnum;
import com.rocogz.merchant.service.merchant.label.service.impl.MerchantLabelServiceImpl;
import com.rocogz.syy.common.controller.BaseController;
import com.rocogz.syy.common.response.Response;
import com.rocogz.util.MapUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/merchant/label"})
public class MerchantLabelController
extends BaseController {
    @Autowired
    private MerchantLabelServiceImpl merchantLabelService;

    @GetMapping
    public PageTable<MerchantLabel> searchScrollPage(@RequestParam(required=false, defaultValue="") String name, @RequestParam(required=false, defaultValue="") String prefectureCode, @RequestParam(required=false) StatusEnum status, @RequestParam(defaultValue="20") int limit, @RequestParam(defaultValue="1") int page) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.put("name", StringUtils.wrap((String)name, (String)"%"));
        }
        MapUtils.putNotNull(params, (String)"prefectureCode", (Object)prefectureCode);
        MapUtils.putNotNull(params, (String)"status", (Object)status);
        Page pageQuery = new Page((long)page, (long)limit);
        List<MerchantLabel> list = this.merchantLabelService.searchScrollPage((IPage)pageQuery, params);
        if (list.size() <= 0) {
            return PageTable.EMPTY_PAGE;
        }
        return new PageTable(list, (long)list.size(), 0, "success");
    }

    @PostMapping
    public Response create(@RequestBody MerchantLabel merchantLabel) {
        return this.merchantLabelService.create(merchantLabel);
    }

    @PostMapping(value={"/edit"})
    public Response edit(@RequestBody MerchantLabel merchantLabel) {
        return this.merchantLabelService.edit(merchantLabel);
    }

    @PostMapping(value={"/status"})
    public Object switchStatus(@RequestBody MerchantLabel merchantLabel) {
        if (this.merchantLabelService.updateStatus(merchantLabel) >= 0) {
            return Response.succeed();
        }
        return Response.failure();
    }

    @GetMapping(value={"/{id}"})
    public Response<MerchantLabel> getById(@PathVariable Integer id) {
        return Response.succeed((Object)this.merchantLabelService.getById(id));
    }

    @GetMapping(value={"/getPrefectureByLabelCode"})
    public Response<List<String>> getPrefectureByLabelCode(@RequestParam(value="labelCode") String labelCode) {
        return this.merchantLabelService.getPrefectureByLabelCode(labelCode);
    }

    @GetMapping(value={"/deletePrefectureByCode"})
    public Response deletePrefectureByCode(@RequestParam(value="labelCode") String labelCode, @RequestParam(value="prefectureCodeList") List<String> prefectureCodeList) {
        return this.merchantLabelService.deletePrefectureByCode(labelCode, prefectureCodeList);
    }
}

