/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.merchant.service.merchant.label.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.rocogz.merchant.entity.label.MerchantLabel;
import com.rocogz.merchant.enumerate.SeriaNoTypeEnum;
import com.rocogz.merchant.service.merchant.label.mapper.MerchantLabelMapper;
import com.rocogz.merchant.service.merchant.label.service.IMerchantLabelService;
import com.rocogz.syy.common.basicserialno.service.SerialNoService;
import com.rocogz.syy.common.response.Response;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MerchantLabelServiceImpl
extends ServiceImpl<MerchantLabelMapper, MerchantLabel>
implements IMerchantLabelService {
    @Autowired
    private SerialNoService serialNoService;

    public List<MerchantLabel> searchScrollPage(IPage page, Map query) {
        return ((MerchantLabelMapper)this.baseMapper).search(page, query);
    }

    @Transactional(rollbackFor={Exception.class})
    public Response create(MerchantLabel merchantLabel) {
        try {
            MerchantLabel labelByName = ((MerchantLabelMapper)this.baseMapper).getLabelByName(merchantLabel.getName());
            if (labelByName != null && ListUtils.isEqualList((Collection)merchantLabel.getPrefectureCode(), (Collection)labelByName.getPrefectureCode())) {
                return Response.failure((String)"\u5f53\u524d\u4e13\u533a\u4e0b\u8be5\u6807\u7b7e\u540d\u5df2\u5b58\u5728\uff01");
            }
            String labelCode = this.serialNoService.generateCode(SeriaNoTypeEnum.MERCHANT_LABEL_CODE.toString());
            merchantLabel.setCode(labelCode);
            merchantLabel.setCreateTime(LocalDateTime.now());
            merchantLabel.setUpdateTime(LocalDateTime.now());
            ((MerchantLabelMapper)this.baseMapper).insert(merchantLabel);
            if (merchantLabel.getCode() != null && CollectionUtils.isNotEmpty((Collection)merchantLabel.getPrefectureCode())) {
                ((MerchantLabelMapper)this.baseMapper).insertPrefectureCode(labelCode, merchantLabel.getPrefectureCode());
            }
            return Response.succeed();
        }
        catch (Exception e) {
            return Response.failure((String)"\u65b0\u589e\u5931\u8d25!");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Response edit(MerchantLabel merchantLabel) {
        try {
            MerchantLabel labelByName;
            MerchantLabel oldLabel = (MerchantLabel)this.getById(merchantLabel.getId());
            if (!oldLabel.getName().equals(merchantLabel.getName()) && (labelByName = ((MerchantLabelMapper)this.baseMapper).getLabelByName(merchantLabel.getName())) != null && ListUtils.isEqualList((Collection)merchantLabel.getPrefectureCode(), (Collection)labelByName.getPrefectureCode())) {
                return Response.failure((String)"\u5f53\u524d\u4e13\u533a\u4e0b\u8be5\u6807\u7b7e\u540d\u5df2\u5b58\u5728\uff01");
            }
            merchantLabel.setUpdateTime(LocalDateTime.now());
            ((MerchantLabelMapper)this.baseMapper).updateLabelbyId(merchantLabel);
            ((MerchantLabelMapper)this.baseMapper).deletePrefectureCode(merchantLabel.getCode());
            if (merchantLabel.getCode() != null && CollectionUtils.isNotEmpty((Collection)merchantLabel.getPrefectureCode())) {
                ((MerchantLabelMapper)this.baseMapper).insertPrefectureCode(merchantLabel.getCode(), merchantLabel.getPrefectureCode());
            }
            return Response.succeed();
        }
        catch (Exception e) {
            return Response.failure((String)"\u4fee\u6539\u5931\u8d25!");
        }
    }

    public Response<List<String>> getPrefectureByLabelCode(String labelCode) {
        return Response.succeed(((MerchantLabelMapper)this.baseMapper).getPrefectureByLabelCode(labelCode));
    }

    public int updateStatus(MerchantLabel merchantLabel) {
        return ((MerchantLabelMapper)this.baseMapper).updateLabelbyId(merchantLabel);
    }

    public Response deletePrefectureByCode(String labelCode, List<String> prefectureCodeList) {
        int line = ((MerchantLabelMapper)this.baseMapper).deletePrefectureByCode(labelCode, prefectureCodeList);
        if (line == prefectureCodeList.size()) {
            return Response.succeed();
        }
        return Response.failure((String)"\u5220\u9664\u5931\u8d25!");
    }
}

