package com.rocogz.merchant.dto;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.io.Serializable;

/**
 * 加油站列表
 * @author：liangyongtong
 * @since：2020/6/29
 */
@Data
@NoArgsConstructor
@RequiredArgsConstructor(staticName = "of")
public class GasStationDto implements Serializable {
    /**
     * 商户编码
     */
    @NonNull
    private String code;

    /**
     * 纬度
     */
    @NonNull
    private String lat;

    /**
     * 经度
     */
    @NonNull
    private String lng;

    /**
     * 距离
     */
    private Integer distance;
}
