package com.rocogz.merchant.entity.store;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.Account;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户修改操作日志
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreUlog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 操作项: 新增、修改、上架、下架、作废、提交上架、停业
     */
    private String ulogType;

    /**
     * 标签页: 新增、上架、下架、作废、提交上架、停业时为空；当为修改时，每个标签页为一条记录
     */
    private String tabName;

    /**
     * 操作内容: 新增、上架、下架、作废、提交上架时为空；
     */
    private String ulogContent;

    /**
     * 操作人
     */
    private String ulogUser;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime ulogTime;

    /**
     * 商户编码
     */
    private String storeCode;


}
