package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 商户账号
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreAccount extends IdEntity {

    /**
     * 门店编号
     */
    private String storeCode;

    /**
     * 商户对象
     */
    @TableField(exist = false)
    private MerchantStore store;

    /**
     * 账号: 门店编号+顺序位;登录使用
     */
    private String code;

    /**
     * 账号姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 状态
     */
    private String status;

    /**
     * 密码
     */
    private String password;

    /**
     * 盐
     */
    private String salt;

    /**
     * 操作人
     */
    @TableField(exist = false)
    private String operateUser;
}
