package com.rocogz.merchant.constant;

/**
 * 常量
 * @author：liangyongtong
 * @since：2020/4/6
 */
public final class Constant {

    public final static String MERCHANT_SERVICE_NAME = "merchant-base-service";

    /**
     * 字典表类型
     */
    public class DictType {
        /** 商户状态 */
        public final static String MERCHANT_STORE_STATUS = "MERCHANT_STORE_STATUS";
        /** 评价维度 */
        public final static String EVALUATIVE_DIMENSION = "EVALUATIVE_DIMENSION";
    }

    /**
     * 字典表数据
     */
    public class DictData {
        /** 商户/服务/商品 草稿状态 */
        public final static String MERCHANT_STORE_STATUS_DRAFT = "DRAFT";
        public final static String MERCHANT_STORE_STATUS_DRAFT_LABEL = "新增";

        /** 商户/服务/商品 待审批 */
        public final static String MERCHANT_STORE_STATUS_PENDING = "PENDING";
        public final static String MERCHANT_STORE_STATUS_PENDING_LABEL = "待审批";

        /** 商户/服务/商品 审批不通过 */
        public final static String MERCHANT_STORE_STATUS_REFUSE = "REFUSE";
        public final static String MERCHANT_STORE_STATUS_REFUSE_LABEL = "审批不通过";

        /** 商户/服务/商品 审批通过 */
        public final static String MERCHANT_STORE_STATUS_PASS_LABEL = "审批通过";

        /** 商户/服务/商品 待上架状态 */
        public final static String MERCHANT_STORE_STATUS_STAYINGON = "STAYINGON";
        public final static String MERCHANT_STORE_STATUS_STAYINGON_LABEL = "提交审批";
        /** 商户/服务/商品 上架状态 */
        public final static String MERCHANT_STORE_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_STORE_STATUS_UP_LIST_LABEL = "上架";
        /** 商户/服务/商品 下架状态 */
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST_LABEL = "下架";
        /** 商户/服务/商品 作废状态 */
        public final static String MERCHANT_STORE_STATUS_INVALID = "INVALID";
        public final static String MERCHANT_STORE_STATUS_INVALID_LABEL = "作废";

        /** 商户服务车型：不区分车型 */
        public final static String AREA_SERVICE_CAR_TYPE_ALL = "ALL";
        public final static String AREA_SERVICE_CAR_TYPE_ALL_LABEL = "不区分车型";
        /** 商户服务小型车 */
        public final static String AREA_SERVICE_CAR_TYPE_CAR = "CAR";

        /** 停业类型：日期段 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION = "DATE_SECTION";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION_LABEL = "指定日期段";
        /** 停业类型：周几 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS = "WEEKS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS_LABEL = "每周几";
        /** 停业类型：每月几号 */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS = "DAYS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS_LABEL = "每月几号";
        /** 公共的状态 启用 */
        public final static String COMMON_STATUS_OPEN = "OPEN";
        /** 公共的状态 停用 */
        public final static String COMMON_STATUS_LOCK = "LOCK";
        /** 公共的状态 是 */
        public final static String COMMON_STATUS_YES = "Y";
        /** 公共的状态 否 */
        public final static String COMMON_STATUS_NO = "N";
        /** 专区服务项目范围 */
        public final static String AREA_SERVICE_RANGE_ALL = "AREA_SERVICE_RANGE_ALL";



        /** 供应商 新增/修改 */
        public final static String MERCHANT_SUPPLIER_CREATE_LABEL = "新增";
        public final static String MERCHANT_SUPPLIER_UPDATE_LABEL = "修改";

        /** 供应商 合作 */
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION = "COOPERATION";
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION_LABEL = "合作";

        /** 供应商 已作废 */
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE = "DELETE";
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE_LABEL = "已作废";

        /** 供应商 已中止 */
        public final static String MERCHANT_SUPPLIER_STATUS_STOP = "STOP";
        public final static String MERCHANT_SUPPLIER_STATUS_STOP_LABEL = "已中止";

    }

    /**
     * 普通常量
     */
    public class General {
        /** 商户停业项提示内容 */
        public final static String MERCHANT_STORE_STOP_BUSINESS_LABEL = "停业";
        /** 商户修改项提示内容 */
        public final static String MERCHANT_STORE_OPERATE_LABEL = "修改";
        /** 商户标签:基本信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_BASE = "基本信息";
        /** 商户标签:营业信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_BUSINESS = "营业信息";
        /** 商户标签:行业信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_INDUSTRY = "行业信息";
        /** 商户标签:账号信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_ACCOUNT = "账号信息";
        /** 商户标签:结算信息 */
        public final static String MERCHANT_STORE_UPDATE_TAB_SETTLE = "结算信息";

        /** 设置为精选评价 */
        public final static String MERCHANTEVALUATEKPI_ADD = "ADD";
        /** 取消精选评价 */
        public final static String MERCHANTEVALUATEKPI_CANCEL = "CANCEL";
        /** 删除 评价 */
        public final static String MERCHANTEVALUATEKPI_DELETE = "DELETE";
        /** 隐藏 评价 */
        public final static String MERCHANTEVALUATEKPI_HIDE = "HIDE";
        /** 显示评价 */
        public final static String MERCHANTEVALUATEKPI_SHOW = "SHOW";
    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /** 商户编码序列编号 */
        public final static String MERCHANT_STORE_CODE = "MERCHANT_STORE_CODE";
        /** 商户账号编码 */
        public final static String MERCHANT_STORE_ACCOUNT_CODE = "MERCHANT_SA_CODE";
        /** 专区服务项目编码 */
        public final static String AREA_SERVICE_CODE = "AREA_SERVICE_CODE";
        /** 专区服务项目结算价格编码 */
        public final static String AREA_SERVICE_SETTLE_CODE = "AREA_SERVICE_SETTLE_CODE";
        /** 商户服务项目编码 **/
        public final static String STORE_SERVICE_CODE = "STORE_SERVICE_CODE";
        /** 商品编码序列编号 */
        public final static String MERCHANT_GOODS_CODE = "MERCHANT_GOODS_CODE";
        /** 供应商编码 */
        public final static String MERCHANT_SUPPLIER_CODE = "MERCHANT_SUPPLIER_CODE";

    }

    /**
     * Redis缓存键值
     */
    public class RedisKey {

        /** 车主端推荐的商户缓存开始编码：后面 + 商户编码 作为一个 key */
        public final static String CAR_INDEX_STORE_START = "RECOMMEND:";

        /** 加油站对应商户类型存储的商户编码 */
        public final static String GAS_STATION_TYPE = "GS_TYPE:";
        /** 加油站对应品牌存储的商户编码 */
        public final static String GAS_STATION_BRAND = "GS_BRAND:";
        /** 加油站对应的商户列表（含商户编码，经纬度） */
        public final static String GAS_STATION_LIST = "GS_LIST";

    }


    /**
     * 商户回调接口配置
     */
    public class MerchantCallback {
        public final static String MERCHANT_STORE_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/store/storeApproveCallBlack";

        public final static String MERCHANT_GOODS_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/goods/goodsApproveCallBlack";
    }
}
