package com.rocogz.merchant.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 评价传参需要参数
 * @author：liangyongtong
 * @since：2020/5/20
 */
@Data
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class EvaluateDto implements Serializable {

    /**
     * 专区编码
     */
    @NotEmpty
    private String areaCode;

    /**
     * 专区服务项目编码
     */
    @NotEmpty
    private String areaServiceCode;

    /**
     * 商户编码
     */
    @NotEmpty
    private String storeCode;

    /**
     * 商户服务项目编码
     */
    @NotEmpty
    private String storeServiceCode;

    /**
     * 印象标签列表
     */
    private List<String> labels;

    /**
     * 商户平均分
     */
    private BigDecimal storeScore;

    /**
     * 商户服务项目平均分
     */
    private BigDecimal storeServiceScore;
}
