package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <dl>
 * <dd>Description:商户商品库存 </dd>
 * <dd>@date: 2020/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoodsStock  extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * 商品信息,库存展示列表和详情中都会用到，为了方面通过Mapper.xml关联查询得到商品的基本信息
     * 然后后，再单独查询供应商，分类，品牌等信息
     */
    @TableField(exist = false)
    private MerchantGoods merchantGoods;

    /**
     * 已售良品库存
     */
    private Integer saleStock;


    /**
     * 累计入库良品库存
     */
    private Integer stock;

    /**
     * 良品占用库存,下单占用库存时只增加 occupiedStock，同时更新 sellableStock
     */
    private Integer occupiedStock;

    /**
     * 次品库存
     */
    private Integer defectStock;

    /**
     * 可售良品库存=stock-saleStock-occupiedStock
     */
    private Integer sellableStock;

    /**
     * 预警库存
     */
    private Integer warnStock;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantGoodsStockLog> logs;

}
