package com.rocogz.merchant.entity.exchangeGoods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.entity.goods.MerchantGoods;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 兑换商品基本信息表
 * </p>
 *
 * @author yinshihao
 * @since 2020-08-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantExchangeGoods extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * 排序值
     */
    private Integer seq;

    /**
     * 状态
     */
    private String status;

    /**
     * 商品
     */
    @TableField(exist = false)
    private MerchantGoods merchantGoods;

    /**
     * 指定角色信息列表
     */
    @TableField(exist = false)
    private List<MerchantExchangeGoodsSpecialPrice> appointRoleList;

    /**
     * 指定用户信息列表
     */
    @TableField(exist = false)
    private List<MerchantExchangeGoodsSpecialPrice> appointUserList;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantExchangeGoodsLog> logs;

    /**
     * 是否有代理人价格
     */
    @TableField(exist = false)
    private Boolean haveAgentPrice;

    /**
     * 最低指定价格
     */
    @TableField(exist = false)
    private BigDecimal minAppointPrice;

    /**
     * 可售良品库存=stock-saleStock-occupiedStock
     */
    @TableField(exist = false)
    private Integer sellableStock;

}
