package com.rocogz.merchant.entity.storeservice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 服务项目车型价格
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreServicePrice extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户服务项目编码
     */
    private String serviceCode;

    /**
     * 车型key
     */
    private String modelKey;

    /**
     * 车型name
     */
    private String modelName;

    /**
     * 结算商结算价
     */
    private BigDecimal settlePrice;

    /**
     * 商户结算价
     */
    private BigDecimal storePrice;

    /**
     * 门市价
     */
    private BigDecimal marketPrice;

    /**
     * 兑换价
     */
    private BigDecimal exchangePrice;

}
