package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商户基本信息表
 * </p>
 *
 * @author yinshihao
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoods extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String code;

    /**
     * 商户名称
     */
    private String name;

    /**
     * 商品分类编码
     */
    private String goodsClassificationCode;

    /**
     * 商品分类对象
     */
    @TableField(exist = false)
    private MerchantGoodsClassification goodsClassification;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商对象
     */
    @TableField(exist = false)
    private MerchantSupplier supplier;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 品牌对象
     */
    @TableField(exist = false)
    private MerchantBrand brand;

    /**
     * 是否虚拟商品(Y:是,N:否)
     */
    private String invented;

    /**
     * 列表图:路径可能会被分割成几个对应比列的图
     */
    private String listView;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;

    /**
     * 商品详情介绍
     */
    private String introduce;

    /**
     * 商品状态
     */
    private String status;

    /**
     * ERP商品码
     */
    private String erpGoodsCode;

    /**
     * 销售价
     */
    private BigDecimal salePrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 搜索关键字
     */
    private String keyword;

    /**
     * 销售类型(分为电销款和渠道款)
     */
    private String saleType;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantGoodsLog> logs;

    /**
     * 销售亮点
     */
    private String saleLightPoint;
}
