package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.attechment.MerchantAttechment;
import com.rocogz.merchant.entity.brand.MerchantBrand;
import com.rocogz.merchant.entity.product.MerchantProductType;
import com.rocogz.merchant.entity.supplier.MerchantSupplier;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商户基本信息表
 * </p>
 *
 * @author yinshihao
 * @since 2020-06-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantGoods extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商品编码
     */
    private String code;

    /**
     * 商户名称
     */
    private String name;

    /**
     * 商品分类编码
     */
    private String goodsClassificationCode;

    /**
     * 商品分类对象
     */
    @TableField(exist = false)
    private MerchantGoodsClassification goodsClassification;

    /**
     * 供应商编码
     */
    private String supplierCode;

    /**
     * 供应商对象
     */
    @TableField(exist = false)
    private MerchantSupplier supplier;

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 品牌对象
     */
    @TableField(exist = false)
    private MerchantBrand brand;

    /**
     * 是否虚拟商品(Y:是,N:否)
     */
    private String invented;

    /**
     * 列表图:路径可能会被分割成几个对应比列的图
     */
    private String listView;

    /**
     * 详情图片列表
     */
    @TableField(exist = false)
    private List<MerchantAttechment> detailImages;

    /**
     * 商品详情介绍
     */
    private String introduce;

    /**
     * 商品状态
     */
    private String status;

    /**
     * ERP商品码
     */
    private String erpGoodsCode;

    /**
     * 销售价
     */
    private BigDecimal salePrice;

    /**
     * 成本价
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 搜索关键字
     */
    private String keyword;

    /**
     * 销售类型(分为电销款和渠道款)
     */
    private String saleType;

    /**
     * 操作日志
     */
    @TableField(exist = false)
    private List<MerchantGoodsLog> logs;

    /**
     * 销售亮点
     */
    private String saleLightPoint;

    /**
     * 折扣
     */
    @TableField(exist = false)
    private String discount;

    /**
     * 型号
     */
    private String model;

    /**
     * 同品平台(分为京东(JD),天猫(TMALL),苏宁(SUNING)
     */
    private String sameProductPlatform;

    /**
     * 同品平台链接
     */
    private String sameProductPlatformUrl;

    /**
     * 商品详情亮点图片
     */
    private String saleLightPointImg;

    /**
     * 商品参数
     */
    private String goodsParameters;

    /**
     * 同品平台appid
     */
    @TableField(exist = false)
    private String appid;

    /**
     * 产品类型
     */
    private String goodsType;

    /**
     * 同品链接二维码
     */
    private String sameProductPlatformImg;

    /**
     * 产品详情页-亮点
     */
    private String detailSaleLightPoint;

    /**
     * 简称
     */
    private String abbreviation;

    /**
     * 可售良品库存=stock-saleStock-occupiedStock
     */
    @TableField(exist = false)
    private Integer sellableStock;

    /**
     * 收款商户id
     */
    private String mchId;

    /**
     * 收款商户名称
     */
    @TableField(exist = false)
    private String mchName;

    /**
     * 产品类型code
     */
    private String goodsTypeCode;

    /**
     * 产品类型对象
     */
    @TableField(exist = false)
    private MerchantProductType productType;

    /**
     * 产品性质
     */
    private String goodsNature;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    private String supplierGoodsName;

    /**
     * 套餐商品
     */
    @TableField(exist = false)
    private List<MerchantGoodsMeal> mealGoods;
}
