package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 更新权益中心用户券对应的第三方业务编号实体
 * @author：liangyongtong
 * @since：2021/3/15
 */
@Data
@Accessors(chain = true)
public class PowerNoToEquityDto implements Serializable {

    private static final long serialVersionUID = -6928883521718105038L;

    /**
     * 用户券编码
     */
    private String userCouponCode;

    /**
     * 子订单编码
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号
     */
    private String comboOrderItemCode;

    /**
     * 第三方业务编号
     */
    private String thirdBusinessCode;

    /**
     * 状态
     */
    private String powerNoToEquityStatus;

    /**
     * 当前重试次数
     */
    private Integer num;

    /**
     * 是否套餐
     */
    private Boolean isSuite;
}
