package com.rocogz.merchant.dto.scm;

import com.rocogz.merchant.entity.scm.MerchantScmInformation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 发放产品订单信息参数
 * @author：liangyongtong
 * @since：2021/3/9
 */
@Data
@Accessors(chain = true)
public class ScmSendDto implements Serializable {
    private static final long serialVersionUID = 5154035306572354255L;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放主体性质
     */
    private String sourceNature;

    /**
     * 发放客户:合作客户 代理商 其他
     */
    private String sourceCustomer;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放目标平台
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 有效期规则编码
     */
    private String validityRules;

    /**
     * 发放方式:后台批量发放/接口/手工发放
     */
    private String grantWay;

    /**
     * 发放来源平台
     */
    private String grantPlatform;

    /**
     * 申请单号
     * @see MerchantScmInformation#applyNo
     */
    private String applyNo;

    /**
     * 下单业务号:接口发放/后台批量发放
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 生效日期
     */
    private LocalDate effectiveDate;

    /**
     * 失效日期
     */
    private LocalDate invalidDate;

    /**
     * 领取验证规则
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放/业务验证
     */
    private String grantNature;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 单位面额
     */
    private BigDecimal unitFaceValue;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 平台编码
     */
    private String productCode;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 发放会员证件信息
     */
    private String grantIdno;

    /**
     * 发放会员证件类型
     */
    private String grantIdtype;

    /**
     * 发放会员车牌
     */
    private String grantLicence;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 发放会员保单号
     */
    private String policyNumber;
}
