package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/3/12 17:01</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class UpOrderQueryDto {
    /**
     * 上游订单编号
     */
    private String orderItemCode;
    /**
     * 下游订单编号
     */
    private String orderCode;
    /**
     * 合作客户产品编号
     */
    private String customerProductCode;
    /**
     * 合作客户产品名称
     */
    private String customerProductName;
    /**
     * 代理商产品编号
     */
    private String agentProductCode;
    /**
     * 代理商产品名称
     */
    private String agentProductName ;
    /**
     * 平台产品编号
     */
    private String productCode;
    /**
     * 平台产品名称
     */
    private String productName;
    /**
     * 产品类别
     */
    private String productCategoryCode;
    /**
     * 产品分类
     */
    private String productTypeCode;
    private String productTypeName;
    /**
     * 产品性质
     */
    private String goodsNature;
    /**
     * 第三方产品编码
     */
    private String thirdProductCode;
    /**
     * 发放会员手机号
     */
    private String grantMobile;
    /**
     * 发放会员证件类型
     */
    private String grantIdtype;
    /**
     * 发放会员证件信息
     */
    private String grantIdno;
    /**
     * 发放会员车牌号
     */
    private String grantLicence;
    /**
     * 发放会员姓名
     */
    private String grantUsername;
    /**
     * 发放会员保单号
     */
    private String policyNumber;
    /**
     * 真实会员手机号
     */
    private String realMobile;
    /**
     * 第三方业务状态
     */
    private String thirdBusinessStatus;
    /**
     * 第三方业务号
     */
    private String thirdBusinessCode;
    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;
    /**
     * 发放张数
     */
    private String grantNum;
    /**
     * 订单价格
     */
    private String detailPrice;

    /**
     * 领取状态
     */
    private String receiveValidateStatus;

    /**
     * 领取开始时间
     */
    private String receiveValidateTimeStart;
    /**
     * 领取结束时间
     */
    private String receiveValidateTimeEnd;
    /**
     * 发放性质（正常发券，业务验证)
     */
    private String grantNature;

    private LocalDateTime orderTimeStart;
    private LocalDateTime orderTimeEnd;
    private LocalDateTime grantTimeStart;
    private LocalDateTime grantTimeEnd;
    private String writeOffStatus;
    private String orderStatus;
    private String orderItemStatus;
    private Boolean export = false;
    private Integer page = 1;
    private Integer limit = 10;
}
