package com.rocogz.merchant.dto.scm.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * <dl>
 * <dd>Description:下游订单的搜索条件 </dd>
 * <dd>@date: 2021/03/12</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode()
@Accessors(chain = true)
public class ScmAdminDownOrderSearchParamDto {

    /**
     * 下游订单编号
     */
    public String orderCode;
    /**
     * 下游订单状态
     */
    private String orderStatus;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 平台编码
     */
    private String productCode;

    /**
     * 平台名称
     */
    private String productName;

    /**
     * 产品类别
     */
    private String productType;

    /**
     * 产品类型
     */
    private String goodsTypeCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 真实会员手机号
     */
    private String realMobile;

    /**
     * 发放会员姓名
     */
    private String grantUsername;

    /**
     * 下单开始时间
     */
    private String orderTimeStart;

    /**
     * 下单结束时间
     */
    private String orderTimeEnd;

    /**
     * 发放开始时间
     */
    private String grantTimeStart;
    /**
     * 发放结束时间
     */
    private String grantTimeEnd;

    //todo
    /**
     * 领取状态
     */
    private String receiveValidateStatus;

    /**
     * 领取开始时间
     */
    private String receiveValidateTimeStart;
    /**
     * 领取结束时间
     */
    private String receiveValidateTimeEnd;
    /**
     * 发放性质（正常发券，业务验证)
     */
    private String grantNature;
    /**
     * 发放主体
     */
    private String sourceCode;
    /**
     * 发放客户代理商
     */
    private String sourceCustomerAgent;

    /**
     * 发放客户合作客户 数据库的字段对应的都是sourceCustomer
     */
    private String sourceCustomer;

    /**
     * 分页
     */
    private Integer limit = 20;
    /**
     * 当前第几页
     */
    private Integer page = 1;

    /**
     * 是否需要导出
     */
    private Boolean export = Boolean.FALSE;


}
