package com.rocogz.merchant.entity.gears;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 档位管理
 * </p>
 *
 * @author luoyc
 * @since 2020-12-28
 */
@Data
@Accessors(chain = true)
@TableName("merchant_combo_gears")
public class MerchantComboGears extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 档位编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 价值
     */
    private BigDecimal cost;

    /**
     * 状态：生效、失效
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    @TableField(exist = false)
    private Integer page = 1;

    @TableField(exist = false)
    private Integer limit = 10;

}
