package com.rocogz.merchant.entity.cooperationCustomer;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.entity.agent.MerchantAgent;
import com.rocogz.merchant.entity.industry.MerchantIndustry;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 合作客户
 * </p>
 *
 * @author yinshihao
 * @since 2020-12-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantCooperationCustomer extends UserTimeEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 代理商编码
     */
    private String agentCode;

    /**
     * 名称
     */
    private String name;

    /**
     * 简称
     */
    private String abbreviation;

    /**
     * 客户组织机构代码
     */
    private String customerOrganizationCode;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 省名称
     */
    private String provinceName;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区名称
     */
    private String districtName;

    /**
     * 区编码
     */
    private String districtCode;

    /**
     * 街道名称
     */
    private String streetName;

    /**
     * 街道编码
     */
    private String streetCode;

    /**
     * 详细地址
     */
    private String detailAddress;

    /**
     * 客户简介
     */
    private String introduce;

    /**
     * 状态
     */
    private String status;

    /**
     * 客户类别
     */
    private String customerCategory;

    /**
     * 代理商联系人列表
     */
    @TableField(exist = false)
    private MerchantAgent agent;

    /**
     * 合作客户联系人列表
     */
    @TableField(exist = false)
    private List<MerchantCooperationCustomerContacts> customerContacts;

    /**
     * 合作客户行业列表
     */
    @TableField(exist = false)
    private List<MerchantCooperationCustomerIndustry> customerIndustry;

    /**
     * 合作客户行业列表
     */
    @TableField(exist = false)
    private List<MerchantIndustry> industryList;

    /**
     * 合作客户业务场景列表
     */
    @TableField(exist = false)
    private List<MerchantCooperationCustomerScene> customerScene;

    /**
     * 业务模式分类(分A类和B类)
     */
    private String businessModelClassification;

    /**
     * 商务条款描述
     */
    private String commercialTermsDescribe;

    /**
     * 上级合作客户编码,上级合作客户编码为0的为顶级合作客户
     */
    private String pCode;

    /**
     * 上级合作客户名称
     */
    @TableField(exist = false)
    private String pName;

    /**
     * 合作客户等级(默认顶级为1级,其子级为2级,以此类推)
     */
    private Integer level;


    /**
     * 业务基点 Y是，N否
     */
    private String businessBasis;
}
