package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 产品信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmProductInformation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 合作客户产品采购价格
     */
    private BigDecimal customerPurchasePrice;

    /**
     * 合作客户产品市场价/面额
     */
    private BigDecimal customerMarketPrice;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 代理商产品采购价格
     */
    private BigDecimal agentPurchasePrice;

    /**
     * 代理商产品市场价/面额
     */
    private BigDecimal agentMarketPrice;

    /**
     * 平台编码
     */
    private String productCode;

    /**
     * 平台名称
     */
    private String productName;

    /**
     * 产品性质
     * @see Constant.DictData#GOODS_NATURE_ITEM
     */
    private String productNature;

    /**
     * 平台供应商产品编码
     */
    @TableField(exist = false)
    private String thirdProductCode;

    /**
     * 平台采购价格
     */
    private BigDecimal purchasePrice;

    /**
     * 平台市场价/面额
     */
    private BigDecimal marketPrice;

    /**
     * 产品类别
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     */
    private String productType;

    /**
     * 产品使用规则:原基准券编号
     */
    private String couponCode;

    //不存在表中，列表上需要显示
    /**
     * 产品类型名字
     */
    @TableField(exist = false)
    private String goodsTypeName;


}
