package com.rocogz.merchant.client.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发放产品订单参数
 * @author：liangyongtong
 * @since：2021/3/10
 */
@Data
@Accessors(chain = true)
public class ReqScm implements Serializable {

    /**
     * 主订单编码
     */
    private String orderCode;

    /**
     * 订单Item编码
     */
    private String orderItemCode;

    /**
     * 供应商套餐明细订单编号：三级订单编码
     * @see  MerchantScmOrderComboDetail#comboOrderItemCode
     */
    private String comboOrderItemCode;

    /**
     * 用户券编码
     */
    private String userCouponCode;

    /**
     * 用户券发放状态
     * @see Constant.DictData#SCM_USER_COUPON_GRANT_STATUS_SUCCESS
     */
    private String userCouponGrantStatus;

    /**
     * 处理领取额度结果
     */
    private String receiveQuotaStatus;

    /**
     * 用户券发放重试次数
     */
    private Integer userCouponGrantRetryNum;

    /**
     * 用户券发放失败原因
     */
    private String userCouponGrantFailReason;


    /**
     * 该用户券的面值
     */
    private BigDecimal faceValue;

    /**
     * 是否套餐
     */
    private Boolean isSuite;

    /**
     * 手机号
     */
    private String mobile;


    /**
     * @see MerchantScmProductInformation#productType
     */
    private String productType;

    /**
     * @see MerchantScmProductInformation#productNature
     */
    private String productNature;

    /**
     * 申请单编号
     */
    private String applyNo;
    /**
     * 发放性质
     */
    private String grantNature;
}
