package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author：liangyongtong
 * @since：2021/4/20
 */
@Data
@Accessors(chain = true)
public class CoverPayDto implements Serializable {
    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 发送客户
     */
    private String sourceCustomer;

    /**
     * 扣款账户
     */
    private String dedutionCustomerCode;

    /**
     * 扣减金额.
     */
    private BigDecimal amount;

    /**
     * 操作类型.
     */
    private String operateType;

    /**
     * 次数
     */
    private Integer coverPayRetryNum;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 领取验证状态
     */
    private String receiveValidateStatus;
}
