package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 明细订单
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderDetail extends IdEntity {

    private static final long serialVersionUID = 4042786962586393961L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 二级订单分组编码
     */
    private String itemGroupCode;

    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 平台商品编码
     */
    private String productCode;

    /**
     * 平台商品名称
     */
    private String productName;

    /**
     * 产品类别
     * @see Constant.DictData#PRODUCT_TYPE_DRIVING_SERVICE
     */
    private String productType;

    /**
     * 第三方产品编码
     */
    private String thirdProductCode;

    /**
     * 重试次数
     */
    private Integer retryNum;

    /**
     * 最后重试时间
     */
    private LocalDateTime lastestRetryTime;

    /**
     * 回调地址
     */
    private String callbackUrl;

    /**
     * 订单状态(上游订单)
     * @see Constant.DictData#SCM_ORDER_STATUS_PENDING
     */
    private String orderStatus;

    /**
     * 第三方业务状态
     */
    private String thirdBusinessStatus;

    /**
     * 第三方业务号
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;

    /**
     * 第三方失败原因
     */
    private String thirdReason;

    /**
     * 发放张数
     */
    private Integer grantNum;

    /**
     * 用户券发放状态:
     * 待发放或已发放
     * @see Constant.DictData#SCM_USER_COUPON_GRANT_STATUS_PENDING
     */
    private String userCouponGrantStatus;

    /**
     * 用户券发放异常原因
     */
    private String userCouponGrantErrorReason;

    /**
     * 用户券发放重试次数
     */
    private Integer userCouponGrantRetryNum;

    /**
     * 产品性质:单品/供应商定制套餐/平台定制套餐
     * @see Constant.DictData#GOODS_NATURE_ITEM
     */
    private String goodsNature;

    /**
     * 订单核销状态:
     */
    private String writeOffStatus;

    /**
     * 订单核销时间
     */
    private LocalDateTime writeOffTime;

    /**
     * 明细订单面值/金额
     */
    private BigDecimal detailPrice;

    /**
     * 本明细订单发放张数
     */
    private Integer itemGrantNum;

    /**
     * 本明细订单发放成功张数
     */
    private Integer itemGrantSuccessNum;

    /**
     * 本明细订单发放成功时间
     */
    private LocalDateTime itemGrantSuccessTime;

    /**
     * 第三方业务编号更新到权益中心状态
     */
    private String powerNoToEquityStatus;

    /**
     * 第三方业务编号更新到权益中心执行次数
     */
    private Integer powerNoToEquityNum;

    /**
     * 领取验证状态
     */
    private String receiveValidateStatus;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveValidateTime;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;
    /**
     * 备付金扣减状态
     */
    private String coverPayStatus;
    /**
     * 支付流水号
     */
    private String coverFlowCode;
    /**
     * 备付金扣减次数
     */
    private Integer coverPayRetryNum;
    /**
     * 备付金扣减金额
     */
    private BigDecimal coverPayPrice;
    /**
     * 备付金支付时间
     */
    private LocalDateTime coverPayTime;
    /**
     * 备付金领取状态
     */
    private String coverReceiveStatus;

    /**
     * 备付金退款状态
     */
    private String refundStatus;

    /**
     * 备付金退款金额
     */
    private BigDecimal refundPrice;

    //=== 下面的属性用来传值

    //产品订单发放平台信息
    private transient MerchantScmInformation scmGrantInfo;

    //产品订单 目标用户表
    private transient MerchantScmTargetUser scmGrantTargetUser;

    private transient MerchantScmProductInformation scmProductInfo;

}
