package com.rocogz.merchant.client.scm;

import com.rocogz.syy.common.request.PageRequestParameter;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 订单查询
 * @author：liangyongtong
 * @since：2021/4/15
 */
@Data
@Accessors(chain = true)
public class ReqOrder extends PageRequestParameter {
    /**
     * 创建人
     */
    private String createUser;

    /**
     * 交易流水号
     */
    private String tradeFlowCode;

    /**
     * 发放客户
     */
    private String sourceCustomer;

    /**
     * 备付金扣减客户编号
     */
    private String dedutionCustomerCode;

    /**
     * 主订单编码（下游订单编码）
     */
    private String orderCode;

    /**
     * 明细订单编码（上游订单编码）
     */
    private String orderItemCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 开始交易日期
     */
    private String startDate;

    /**
     *  结束交易日期
     */
    private String endDate;

    /**
     * 明细订单编码列表
     */
    private List<String> orderItemCodes;
}
