package com.rocogz.merchant.dto.datapermission;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * <dl>
 * <dd>Description:数据权限使用的类别树 </dd>
 * <dd>@date: 2021/06/05</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class DPCategoryTreeDto {


    public DPCategoryTreeDto() {
        spread=true;
        checkArr=new DtreeCheckArr();
        isRoot=false;
        needIndex=false;
    }

    /**
     * 可以认为就是code和数据权限中的data_type的组合
     * 三部分：code,data_type,权益中whetherCustomer发放主体性质（代理商/合作客户/OTHER）
     */
    private String id;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 标题
     */
    private String title;

    /**
     * 是否展开
     */
    private Boolean spread;

    /**
     * 节点的状态状态，看是否启用，前台没启用的会变颜色
     */
    private String status;

    /**
     * 孩子
     */
    private List<DPCategoryTreeDto> children;

    /**
     * Dtree必须的 如何是
     */
    private DtreeCheckArr checkArr ;
    /**
     *  code
     */
    private String code;
    /**
     * 数据权限类型
     */
    private String dataType;

    /**
     * 类型
     */
    private String nodeTag;

    /**
     * 是否禁用
     */
    private Boolean disabled;

    /**
     * 是否是Root
     */
    private Boolean isRoot;

    /**
     * 是否需要加个序号，应代理商 也出现在 合作客户代理商客户上最好是区分ID
     */
    private Boolean needIndex;


}
