package com.rocogz.merchant.dto.scm.oil;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 供应链系统发放油卡请求实体
 * @author djt
 * @date 2021/3/8
 */
@Data
public class OilRechargeRequest {

    /**
     * 手机号
     */
    @NotNull(message = "手机号不能为空")
    private String phone;

    /**
     * 订单号
     */
    @NotNull(message = "订单号不能为空")
    private String orderNo;

    /**
     * 产品面值
     */
    @NotNull(message = "产品面值不能为空")
    private BigDecimal faceValue;

    /**
     * 产品编号
     */
    @NotBlank(message = "产品编号不能为空")
    private String goodsCode;


}
