package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 供应链发放信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmInformation extends UserTimeEntity {

    private static final long serialVersionUID = 6368647649044093889L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 发放主体
     */
    private String sourceCode;

    /**
     * 发放主体性质
     * @see Constant.DictData#SOURCE_NATURE_AGENT
     */
    private String sourceNature;

    /**
     * 发放客户
     */
    private String sourceCustomer;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;

    /**
     * 扣款账户
     */
    private String dedutionCustomerCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放目标平台
     */
    private String targetPlatform;

    /**
     * 发放目标小程序ID
     */
    private String targetMiniAppid;

    /**
     * 有效期规则编码
     */
    private String validityRules;

    /**
     * 发放方式:后台批量发放/接口/手工发放
     * @see Constant.DictData#GRANT_WAY_BATCH
     */
    private String grantWay;

    /**
     * 发放来源平台
     */
    private String grantPlatform;

    /**
     * 原始发放张数
     */
    private Integer quantity;

    /**
     * 单位面值
     */
    private BigDecimal unitFaceValue;

    /**
     * 申请单号
     */
    private String applyNo;

    /**
     * 下单业务号：即清单编号:接口发放/后台批量发放
     */
    private String businessCode;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期
     */
    private LocalDateTime invalidDate;

    /**
     * 领取验证规则
     */
    private String receiveRules;

    /**
     * 发放业务性质:正常发放/业务验证
     */
    private String grantNature;

    /**
     * 发放主体团队编码
     * @see basic_team_info.team_code
     */
    private String teamCode;

    //-----------传输---------
    //下游详情要用
    /**
     * 发放客户名称
     */
    @TableField(exist = false)
    private String sourceCustomerName;

}
