package com.rocogz.merchant.entity.storeservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.areaservice.MerchantAreaService;
import com.rocogz.merchant.entity.service.ServiceClassification;
import com.rocogz.merchant.entity.store.MerchantStore;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商户服务项目
 * </p>
 *
 * @author liangyongtong
 * @since 2020-04-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantStoreService extends UserTimeEntity {

    private static final long serialVersionUID = 1240955452340922355L;
    /**
     * 商户服务项目编码
     */
    private String code;

    /**
     * 商户服务项目名称
     */
    private String name;

    /**
     * 创建来源
     */
    private String source;

    /**
     * 商户服务项目简称
     */
    private String abbreviation;

    /**
     * 所属商户编码
     */
    private String storeCode;

    /**
     * 商户对象
     */
    @TableField(exist = false)
    private MerchantStore store;

    /**
     * 服务所属分类编码
     */
    private String cataCode;

    /**
     * 商户服务类型对象
     */
    @TableField(exist = false)
    private ServiceClassification cata;

    /**
     * 专区服务项目编号
     */
    private String areaServiceCode;

    /**
     * 专区服务项目对象
     */
    @TableField(exist = false)
    private MerchantAreaService areaService;

    /**
     * 结算方编码
     */
    private String settleCode;

    /**
     * 结算方名称
     */
    private String settleName;

    /**
     * 商户服务项目状态
     */
    private String status;

    /**
     * 服务详细
     */
    private String introduce;

    /**
     * 服务亮点
     */
    private String lightSpot;

    /**
     * 服务图片地址
     */
    private String url;

    /**
     * 是否区分车型 Y/N
     */
    private String distinguish;

    /**
     * 结算方式
     */
    private String settleWay;

    /**
     * 是否套餐 Y/N
     */
    private String combo;

    /**
     * 套餐列表
     */
    @TableField(exist = false)
    private List<MerchantStoreServiceComboRelate> relates;

    /**
     * 显示顺序
     */
    private Integer seq;

    /**
     * 预约状态
     */
    private String appointmentStatus;

    /**
     * 商户服务项目对应的价格
     */
    @TableField(exist = false)
    private List<MerchantStoreServicePrice> prices;

    /**
     * 服务标签列表
     */
    @TableField(exist = false)
    private List<MerchantStoreServiceLabelRelate> labels;

    /**
     * 商户服务项目对应的平均分、订单数
     */
    @TableField(exist = false)
    private MerchantStoreServiceKpi storeServiceKpi;

    /**
     * 预约数量
     */
    @TableField(exist = false)
    private List<MerchantStoreServiceAppointment> appointments;
}
