package com.rocogz.merchant.entity.storeservice;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 商户服务项目修改操作日志
 * </p>
 *
 * @author liangyongtong
 * @since 2020-05-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantStoreServiceUlog extends IdEntity {

    private static final long serialVersionUID = -8683594734093062456L;
    /**
     * 操作项
     */
    private String ulogType;

    /**
     * 操作内容
     */
    private String ulogContent;

    /**
     * 操作人
     */
    private String ulogUser;

    /**
     * 操作人名称
     */
    @TableField(exist = false)
    private String ulogUserName;

    /**
     * 操作时间
     */
    private LocalDateTime ulogTime;

    /**
     * 商户服务项目编码
     */
    private String storeServiceCode;
}
