package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 油站附加基本信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-01-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "merchant_store_oil")
public class MerchantStoreOil extends IdEntity {

    private static final long serialVersionUID=1L;

    private String storeCode;

    /**
     * 油站类型
     */
    private String oilType;

    /**
     * 油站提醒
     */
    private String remind;

    /**
     * 是否有便利店: Y 有 N 无
     */
    private String convenienceStore;

    /**
     * 特别说明
     */
    private String specialInstructions;

    /**
     * 是否有活动:Y 有 N 无
     */
    private String active;

    /**
     * 活动简介
     */
    private String activeIntroduction;

    /**
     * 活动说明
     */
    private String activeExplain;

    /**
     * 是否提供发票: Y 有 N 无
     */
    private String invoice;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 是否有洗美店: Y 有 N 无
     */
    private String washStore;

    /**
     * 是否可洗车: Y 有 N 无
     */
    private String washCar;

    /**
     * 洗车类型
     */
    private String washType;

    /**
     * 洗车机工位
     */
    private Integer washMachineStation;

    /**
     * 洗车工位
     */
    private Integer washStation;

    /**
     * 是否可打气: Y 有 N 无
     */
    private String cheer;

    /**
     * 打气价格
     */
    private BigDecimal cheerPrice;

    /**
     * 气枪数量
     */
    private Integer cheerNum;

    /**
     * 是否显示油品信息:  Y 是 N 否
     */
    private String showOilType;
}
