package com.rocogz.merchant.constant;

/**
 * 常量
 *
 * @author：liangyongtong
 * @since：2020/4/6
 */
public final class Constant {

    private static final long serialVersionUID = 636864764904L;

    public final static String MERCHANT_SERVICE_NAME = "merchant-base-service";

    /**
     * 字典表类型
     */
    public class DictType {
        /**
         * 商户状态
         */
        public final static String MERCHANT_STORE_STATUS = "MERCHANT_STORE_STATUS";
        /**
         * 评价维度
         */
        public final static String EVALUATIVE_DIMENSION = "EVALUATIVE_DIMENSION";
        /**
         * 商户后台库存调整类型 目前有 增加，减少，预警库存，将来可能有库存占用，占用取消，库存还原等
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_TYPE = "MERCHANT_GOODS_STOCK_OPERATE_TYPE";

        /**
         * 商户后台库存调整类型 目前有 增加，减少，预警库存，将来可能有库存占用，占用取消，库存还原等
         */
        public final static String OPPOINTROLE = "OPPOINTROLE";

        /**
         * 虚拟卡券状态
         */

        public final static String MERCHANT_GOODS_VCARD_STATUS = "MERCHANT_GOODS_VCARD_STATUS";
        /**
         * 虚拟卡券类型
         */
        public final static String MERCHANT_GOODS_VCARD_TYPE = "MERCHANT_GOODS_VCARD_TYPE";

        /**
         * 礼品选择过滤系数设置
         */
        public final static String GIFT_FILTER_COEFFICENT = "GIFT_FILTER_COEFFICENT";

        /**
         * 客户类型
         */
        public final static String CUSTOMER_TYPE = "CUSTOMER_TYPE";
        /**
         * 客户类别
         */
        public final static String CUSTOMER_CATEGORY = "CUSTOMER_CATEGORY";
        /**
         * 业务场景
         */
        public final static String BUSINESS_SCENARIOS = "BUSINESS_SCENARIOS";
        /**
         * 商户数据
         */
        public final static String MERCHANT_STORE_DATA = "MERCHANT_STORE_DATA";
        /**
         * 合作客户状态
         */
        public final static String MERCHANT_CUSTOMER_GOODS_STATUS = "MERCHANT_CUSTOMER_GOODS_STATUS";
        /**
         * 代理商产品状态
         */
        public final static String MERCHANT_AGENT_GOODS_STATUS = "MERCHANT_AGENT_GOODS_STATUS";
        /**
         * 平台产品类型
         */
        public final static String PLATEFORM_GOODS_TYPE = "PLATEFORM_GOODS_TYPE";
        /**
         * 上游券发放模式
         */
        public final static String SUPPLIER_GRANT_MODE = "SUPPLIER_GRANT_MODE";

        /**
         * 供应链订单类型
         */
        public final static String SCM_ORDER_TYPE = "SCM_ORDER_TYPE";
    }

    /**
     * 字典表数据
     */
    public class DictData {
        /**
         * 商户系数
         */
        public final static String COEFFICIENT = "COEFFICIENT";
        /**
         * 投保礼 上架状态
         */
        public final static String MERCHANT_TOTAL_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_TOTAL_STATUS_UP_LIST_LABEL = "上架";
        /**
         * 投保礼 下架状态
         */
        public final static String MERCHANT_TOTAL_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_TOTAL_STATUS_DOWN_LIST_LABEL = "下架";
        /**
         * 投保礼 待上架状态
         */
        public final static String MERCHANT_TOTAL_STATUS_STAYINGON = "STAYINGON";
        public final static String MERCHANT_TOTAL_STATUS_STAYINGON_LABEL = "待上架";


        /**
         * 商户/服务/商品 草稿状态
         */
        public final static String MERCHANT_STORE_STATUS_DRAFT = "DRAFT";
        public final static String MERCHANT_STORE_STATUS_DRAFT_LABEL = "新增";

        /**
         * 商户/服务/商品 待审批
         */
        public final static String MERCHANT_STORE_STATUS_PENDING = "PENDING";
        public final static String MERCHANT_STORE_STATUS_PENDING_LABEL = "待审批";

        /**
         * 商户/服务/商品 审批不通过
         */
        public final static String MERCHANT_STORE_STATUS_REFUSE = "REFUSE";
        public final static String MERCHANT_STORE_STATUS_REFUSE_LABEL = "审批不通过";

        /**
         * 商户/服务/商品 审批通过
         */
        public final static String MERCHANT_STORE_STATUS_PASS_LABEL = "审批通过";

        /**
         * 商户/服务/商品 待上架状态
         */
        public final static String MERCHANT_STORE_STATUS_STAYINGON = "STAYINGON";
        public final static String MERCHANT_STORE_STATUS_STAYINGON_LABEL = "提交审批";
        /**
         * 商户/服务/商品 上架状态
         */
        public final static String MERCHANT_STORE_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_STORE_STATUS_UP_LIST_LABEL = "上架";
        /**
         * 商户/服务/商品 下架状态
         */
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_STORE_STATUS_DOWN_LIST_LABEL = "下架";
        /**
         * 商户/服务/商品 作废状态
         */
        public final static String MERCHANT_STORE_STATUS_INVALID = "INVALID";
        public final static String MERCHANT_STORE_STATUS_INVALID_LABEL = "作废";

        /**
         * 兑换商品 待上架状态
         */
        public final static String EXCHANGE_GOODS_STATUS_WAIT_UP_LIST = "WAIT_UP_LIST";
        public final static String EXCHANGE_GOODS_STATUS_WAIT_UP_LIST_LABEL = "待上架";
        /**
         * 商户服务车型：不区分车型
         */
        public final static String AREA_SERVICE_CAR_TYPE_ALL = "ALL";
        public final static String AREA_SERVICE_CAR_TYPE_ALL_LABEL = "不区分车型";
        /**
         * 商户服务小型车
         */
        public final static String AREA_SERVICE_CAR_TYPE_CAR = "CAR";

        /**
         * 停业类型：不歇
         */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WORK = "WORK";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WORK_LABEL = "不歇";
        /**
         * 停业类型：日期段
         */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION = "DATE_SECTION";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DATE_SECTION_LABEL = "指定日期段";
        /**
         * 停业类型：周几
         */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS = "WEEKS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_WEEKS_LABEL = "每周几";
        /**
         * 停业类型：每月几号
         */
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS = "DAYS";
        public final static String MERCHANT_STORE_BUSINESS_TYPE_DAYS_LABEL = "每月几号";
        /**
         * 公共的状态 启用
         */
        public final static String COMMON_STATUS_OPEN = "OPEN";
        /**
         * 公共的状态 停用
         */
        public final static String COMMON_STATUS_LOCK = "LOCK";
        /**
         * 公共的状态 是
         */
        public final static String COMMON_STATUS_YES = "Y";
        /**
         * 公共的状态 否
         */
        public final static String COMMON_STATUS_NO = "N";

        /**
         * 公共状态： 成功
         */
        public final static String COMMON_STATUS_SUCCESS = "SUCCESS";

        /**
         * 公共状态： 失败
         */
        public final static String COMMON_STATUS_FAILURE = "FAILURE";

        /**
         * 专区服务项目范围
         */
        public final static String AREA_SERVICE_RANGE_ALL = "AREA_SERVICE_RANGE_ALL";


        /**
         * 供应商 新增/修改
         */
        public final static String MERCHANT_SUPPLIER_CREATE_LABEL = "新增";
        public final static String MERCHANT_SUPPLIER_UPDATE_LABEL = "修改";

        /**
         * 供应商 合作
         */
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION = "COOPERATION";
        public final static String MERCHANT_SUPPLIER_STATUS_COOPERATION_LABEL = "合作";

        /**
         * 供应商 已作废
         */
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE = "DELETE";
        public final static String MERCHANT_SUPPLIER_STATUS_DELETE_LABEL = "已作废";

        /**
         * 供应商 已中止
         */
        public final static String MERCHANT_SUPPLIER_STATUS_STOP = "STOP";
        public final static String MERCHANT_SUPPLIER_STATUS_STOP_LABEL = "已中止";


        /**
         * 预警库存调整，但不出出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_WARN = "WARN";
        public final static String MERCHANT_GOODS_STOCK_OPERATE_WARN_LABEL = "调整预警库存";

        /**
         * 后台的增加库存调整，出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_ADD_STOCK = "ADD_STOCK";
        public final static String MERCHANT_GOODS_STOCK_OPERATE_ADD_STOCK_LABEL = "增加良品库存";

        /**
         * 后台减少库存调整，出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_REDUCE_STOCK = "REDUCE_STOCK";
        public final static String MERCHANT_GOODS_STOCK_OPERATE_REDUCE_STOCK_LABEL = "减少良品库存";


        /**
         * 预警库存调整，但不出出现在字典数据中
         */
        public final static String MERCHANT_GOODS_STOCK_OPERATE_OCCUPIED = "occupied";
        public final static String MERCHANT_GOODS_STOCK_OPERATE_OCCUPIED_LABEL = "调整占用库存";


        /**
         * 虚拟卡的卡密类型
         */
        public final static String VCARD_CARDTYPE_CARD = "CARD";//卡号密码
        public final static String VCARD_CARDTYPE_PASSWORD = "PASSWORD";//卡密
        public final static String VCARD_CARDTYPE_EXCHANGE = "EXCHANGE";//兑换码


        /**
         * 虚拟卡状态
         */
        public final static String VCARD_STATUS_NOT_USED = "NOT_USED";//未使用
        public final static String VCARD_STATUS_USED = "USED";//已使用
        public final static String VCARD_STATUS_EXPIRED = "EXPIRED";//已过期
        public final static String VCARD_STATUS_TO_VOID = "TO_VOID";//已作废

        // 设保礼礼品类型
        /**
         * 组合套餐
         **/
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE = "PACKAGE";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PACKAGE_LABEL = "组合套餐";
        /**
         * 项目
         */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT = "PROJECT";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_PROJECT_LABEL = "项目";
        /**
         * 商品
         */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_GOODS = "GOODS";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_GOODS_LABEL = "商品";
        /**
         * 代金券
         */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON = "COUPON";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_COUPON_LABEL = "代金券";

        /**
         * 代金券
         */
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_CASH = "CASH";
        public final static String MERCHANT_INSURANCE_GIFT_TYPE_CASH_LABEL = "现金";

        // 礼品选择过滤系数设置
        /**
         * 成本系数
         */
        public final static String GIFT_FILTER_COEFFICENT_COST_COEFFICENT = "COST_COEFFICENT";
        /**
         * 膨胀系数
         */
        public final static String GIFT_FILTER_COEFFICENT_INFLATION_COEFFICENT = "INFLATION_COEFFICENT";
        /**
         * 膨胀系数
         */
        public final static String GIFT_FILTER_COEFFICENT_REMAIN_FLOATING_COEFFICENT = "REMAIN_FLOATING_COEFFICENT";
        /**
         * 预算价格系数
         */
        public static final String GIFT_FILTER_COEFFICENT_REMAIN_PRICE_COEFFICENT = "REMAIN_PRICE_COEFFICENT";

        /**
         * 商品类型-兑换商品
         */
        public final static String EXCHANGE_GOODS = "EXCHANGE_GOODS";
        /**
         * 商品类型-赠送商品
         */
        public final static String GIVE_GOODS = "GIVE_GOODS";
        /**
         * 商品类型-特惠专区
         */
        public final static String SPECIAL_ZONE = "SPECIAL_ZONE";
        /**
         * 商品类型-ROCO特惠商城
         */
        public final static String ROCO_SPECIAL_MALL = "ROCO_SPECIAL_MALL";

        /**
         * 代理商产品 上架状态
         */
        public final static String MERCHANT_AGENT_GOODS_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_AGENT_GOODS_STATUS_UP_LIST_LABEL = "上架";
        /**
         * 代理商产品 下架状态
         */
        public final static String MERCHANT_AGENT_GOODS_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_AGENT_GOODS_STATUS_DOWN_LIST_LABEL = "下架";

        /**
         * 合作客户产品 上架状态
         */
        public final static String MERCHANT_CUSTOMER_GOODS_STATUS_UP_LIST = "UP_LIST";
        public final static String MERCHANT_CUSTOMER_GOODS_STATUS_UP_LIST_LABEL = "上架";
        /**
         * 合作客户产品 下架状态
         */
        public final static String MERCHANT_CUSTOMER_GOODS_STATUS_DOWN_LIST = "DOWN_LIST";
        public final static String MERCHANT_CUSTOMER_GOODS_STATUS_DOWN_LIST_LABEL = "下架";


        /**
         * 套餐类型-服务项目
         */
        public final static String MERCHANT_COMBO_DETAIL_TYPE_PROJECT = "PROJECT";
        /**
         * 套餐类型-加油代金券
         */
        public final static String MERCHANT_COMBO_DETAIL_TYPE_OIL_CASH = "OIL_CASH";
        /**
         * 套餐类型-电子油卡券
         */
        public final static String MERCHANT_COMBO_DETAIL_TYPE_OIL_CARD_DIGITAL = "OIL_CARD_DIGITAL";
        /**
         * 套餐类型-代驾券
         */
        public final static String MERCHANT_COMBO_DETAIL_TYPE_DRIVING_SERVICE = "DRIVING_SERVICE";

        /*** 油站营业状态 */
        public final static String MERCHANT_STORE_BUSINESS_STATUS = "BUSINESS_STATUS";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_WORKING = "WORKING";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_WORKING_LABEL = "正常营业";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_OPENING_SOON = "OPENING_SOON";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_OPENING_SOON_LABEL = "即将营业";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_CLOSE_DOWN = "CLOSE_DOWN";
        public final static String MERCHANT_STORE_BUSINESS_STATUS_CLOSE_DOWN_LABEL = "停业";

        /**
         * 油品类型
         */
        public final static String MERCHANT_STORE_OIL_TYPE = "OIL_TYPE";

        /**
         * 商户账号操作权限
         */
        public final static String MERCHANT_ACCOUT_PERMISSION = "MERCHANT_ACCOUT_PERMISSION";

        /**
         * 商品采购方式
         */
        public final static String MERCHANT_PURCHASEWAY = "PURCHASEWAY";
        public final static String MERCHANT_PURCHASEWAY_COMBO = "COMBO";
        public final static String MERCHANT_PURCHASEWAY_COMBO_LABEL = "只含在套餐中采购";
        public final static String MERCHANT_PURCHASEWAY_SINGLE = "SINGLE";
        public final static String MERCHANT_PURCHASEWAY_SINGLE_LABEL = "可单品采购";

        /**
         * 客户类别:代理商客户
         */
        public final static String CUSTOMER_CATEGORY_AGENTC = "AgentC";
        /**
         * 客户类别:平台直营客户
         */
        public final static String CUSTOMER_CATEGORY_DIRECTC = "DirectC";

        /**
         * scm订单状态(下游订单状态)
         */
        public final static String SCM_DOWN_ORDER_STATUS = "SCM_DOWN_ORDER_STATUS";

        /**
         * scm明细订单状态(上游订单状态)
         */
        public final static String SCM_UP_ORDER_STATUS = "SCM_UP_ORDER_STATUS";

        /**
         * 产品明细订单状态：待发放
         */
        public final static String SCM_ORDER_STATUS_PENDING = "PENDING";
        /**
         * 产品明细订单状态：发放中
         */
        public final static String SCM_ORDER_STATUS_IN_PROCESS = "IN_PROCESS";
        /**
         * 产品明细订单状态：已发放
         */
        public final static String SCM_ORDER_STATUS_SUCCESS = "SUCCESS";
        /**
         * 产品明细订单状态：已作废
         */
        public final static String SCM_ORDER_STATUS_CANCEL = "CANCEL";
        /**
         * 产品明细订单状态：已退回
         */
        public final static String SCM_ORDER_STATUS_BACK = "BACK";
        /**
         * 产品明细订单状态：发放失败
         */
        public final static String SCM_ORDER_STATUS_FAILURE = "FAILURE";

        /**
         * 产品套餐明细订单状态：待发放
         */
        public final static String SCM_ORDER_COMBO_STATUS_PENDING = "PENDING";
        /**
         * 产品套餐明细订单状态：发放中
         */
        public final static String SCM_ORDER_COMBO_STATUS_IN_PROCESS = "IN_PROCESS";
        /**
         * 产品套餐明细订单状态：已发放
         */
        public final static String SCM_ORDER_COMBO_STATUS_SUCCESS = "SUCCESS";
        /**
         * 产品套餐明细订单状态：已作废
         */
        public final static String SCM_ORDER_COMBO_STATUS_CANCEL = "CANCEL";
        /**
         * 产品套餐明细订单状态：已退回
         */
        public final static String SCM_ORDER_COMBO_STATUS_BACK = "BACK";
        /**
         * 产品套餐明细订单状态：发放失败
         */
        public final static String SCM_ORDER_COMBO_STATUS_FAILURE = "FAILURE";

        /**
         * 供应链订单使用状态
         */
        public final static String SCM_USE_STATUS = "SCM_USE_STATUS";
        /**
         * 供应链订单使用状态: 未使用
         */
        public final static String SCM_USE_STATUS_NORMAL = "NORMAL";
        /**
         * 供应链订单使用状态: 已使用
         */
        public final static String SCM_USE_STATUS_USED = "USED";
        /**
         * 供应链订单使用状态: 已过期
         */
        public final static String SCM_USE_STATUS_INVALID = "INVALID";
        /**
         * 供应链订单使用状态: 已作废
         */
        public final static String SCM_USE_STATUS_CANCEL = "CANCEL";

        /**
         * 用户券发放状态
         */
        public final static String SCM_USER_COUPON_GRANT_STATUS = "SCM_USER_COUPON_GRANT_STATUS";

        /**
         * 用户券发放状态: 待发放
         */
        public final static String SCM_USER_COUPON_GRANT_STATUS_PENDING = "PENDING";
        /**
         * 用户券发放状态: 发放失败
         */
        public final static String SCM_USER_COUPON_GRANT_STATUS_FAILURE = "FAILURE";

        /**
         * 用户券发放状态: 发放中
         */
        public final static String SCM_USER_COUPON_GRANT_STATUS_IN_PROCESS = "IN_PROCESS";
        /**
         * 用户券发放状态: 已发放
         */
        public final static String SCM_USER_COUPON_GRANT_STATUS_SUCCESS = "SUCCESS";

        /**
         * 产品性质-字典类型编码
         */
        public final static String GOODS_NATURE_CODE = "GOODS_NATURE";
        /**
         * 产品性质: 单品
         */
        public final static String GOODS_NATURE_ITEM = "ITEM";
        /**
         * 产品性质: 供应商定制套餐
         */
        public final static String GOODS_NATURE_SUPPLIER_MEAL = "SUPPLIER_MEAL";
        /**
         * 产品性质: 平台定制套餐
         */
        public final static String GOODS_NATURE_PLATFORM_MEAL = "PLATFORM_MEAL";


        /**
         * 产品订单发放方式-字典类型编码
         */
        public final static String GRANT_WAY_TYPE = "GRANT_WAY_TYPE";
        /**
         * 产品订单发放方式: 批量
         */
        public final static String GRANT_WAY_BATCH = "BATCH";

        /**
         * 后台批量生成兑换码领取
         */
        public static final String EXCHANGE_RECEIVE = "EXCHANGE_RECEIVE";

        /**
         * 产品订单发放方式: 接口
         */
        public final static String GRANT_WAY_INTERFACE = "INTERFACE";
        /**
         * 产品订单发放方式: 手工
         */
        public final static String GRANT_WAY_MANUAL = "MANUAL";
        /**
         * 产品订单发放方式: 积分兑换
         */
        public final static String GRANT_WAY_EXCHANGE = "EXCHANGE";

        /**
         * 平台产品 产品类别-字典类型编码
         */
        public final static String PRODUCT_TYPE = "PLATEFORM_GOODS_TYPE";
        /**
         * 平台产品 产品类别: 电子油卡券直充,面额=1,可以输入直充自定义金额
         */
        public final static String PRODUCT_TYPE_OIL_CARD_DIGITAL_YES = "OIL_CARD_DIGITAL_YES";
        /**
         * 平台产品 产品类别: 电子油卡券非直充，就是固定面额
         */
        public final static String PRODUCT_TYPE_OIL_CARD_DIGITAL = "OIL_CARD_DIGITAL";
        /**
         * 平台产品 产品类别: 加油代金券
         */
        public final static String PRODUCT_TYPE_OIL_CASH = "OIL_CASH";
        /**
         * 平台产品 产品类别: 代驾券
         */
        public final static String PRODUCT_TYPE_DRIVING_SERVICE = "DRIVING_SERVICE";
        /**
         * 平台产品 产品类别: 第三方套餐券
         */
        public final static String PRODUCT_TYPE_PACKAGE = "PACKAGE";
        /**
         * 平台产品 产品类别: 年审代金券
         */
        public final static String PRODUCT_TYPE_YEAR_REVIEW_CASH = "YEAR_REVIEW_CASH";
        /**
         * 平台产品 产品类别: 服务券
         */
        public final static String PRODUCT_TYPE_SERVICE = "SERVICE";
        /**
         * 平台产品 产品类别: 第三方跳转产品
         */
        public final static String PRODUCT_TYPE_THIRD_JUMP = "THIRD_JUMP";
        /**
         * 平台产品 产品类别: 积分券
         */
        public final static String POINT = "POINT";

        /**
         * 订单核销状态
         */
        public final static String SCM_ORDER_WRITE_OFF_STATUS = "SCM_ORDER_WRITE_OFF_STATUS";
        /**
         * 订单核销状态： 已核销
         */
        public final static String SCM_ORDER_WRITE_OFF_STATUS_WRITE_OFF = "WRITE_OFF";
        /**
         * 订单核销状态： 未核销
         */
        public final static String SCM_ORDER_WRITE_OFF_STATUS_NORMAL = "NORMAL";
        /**
         * 订单核销状态： 已过期
         */
        public final static String SCM_ORDER_WRITE_OFF_STATUS_INVALID = "INVALID";

        /**
         * 证件类型-字典类型编码
         */
        public final static String ID_TYPE_CODE = "IDTYPE";

        /**
         * 用户券更新回调状态-字典类型编码
         */
        public final static String ORDER_ROCO_USER_COUPON_CALL_BACK_STATUS = "ORDER_ROCO_USER_COUPON_CALL_BACK_STATUS";
        /**
         * 用户券更新回调状态-回调失败
         */
        public final static String ORDER_ROCO_USER_COUPON_CALL_BACK_STATUS_FAILURE = "FAILURE";
        /**
         * 用户券更新回调状态-回调成功
         */
        public final static String ORDER_ROCO_USER_COUPON_CALL_BACK_STATUS_SUCCESS = "SUCCESS";

        /**
         * 发放业务性质-字典类型编码
         */
        public final static String USER_COUPON_NATURE = "USER_COUPON_NATURE"; //包含业务验证，正常发放

        /**
         * 发放主体性质：代理商
         */
        public final static String SOURCE_NATURE_AGENT = "AGENT";
        /**
         * 发放主体性质：合作客户
         */
        public final static String SOURCE_NATURE_CUSTOMER = "CUSTOMER";
        /**
         * 发放主体性质：其他
         */
        public final static String SOURCE_NATURE_OTHER = "OTHER";


        // 下游订单操作日志类型
        public final static String SCM_ORDER_OPERATE_TYPE = "SCM_ORDER_OPERATE";
        /** 创建订单 */
        public final static String SCM_ORDER_OPERATE_CREATE = "CREATE";
        /** 发放用户券 */
        public final static String SCM_ORDER_OPERATE_UPDATE_COUPON = "UPDATE_COUPON";
        /** 核销 */
        public final static String SCM_ORDER_OPERATE_WRITE_OFF = "WRITE_OFF";
        /**
         * 订单撤回
         */
        public final static String SCM_ORDER_OPERATE_RECALL = "RECALL";

        // 下游订单调用日志类型
        public final static String SCM_CALL_LOG_TYPE = "SCM_CALL_LOG";
        /** 调用权益发放用户券 */
        public final static String SCM_CALL_LOG_GRANT_COUPON = "GRANT_COUPON";
        /** 更新第三方业务编号到权益中心 */
        public final static String SCM_CALL_LOG_UPDATE_EQUITY = "UPDATE_EQUITY";
        /** 调用上游分支处理 */
        public final static String SCM_CALL_LOG_BRANCH_HANDLE = "BRANCH_HANDLE";
        /** 订单支付 */
        public final static String SCM_CALL_LOG_ORDER_PAY = "ORDER_PAY";
        /**
         * 额度退款
         */
        public final static String SCM_CALL_LOG_ORDER_REFUND = "ORDER_REFUND";

        /** 备付金支付 */
        public final static String SCM_CALL_LOG_COVER_PAY = "COVER_PAY";
        /** 备付金退款 */
        public final static String SCM_CALL_LOG_COVER_REFUND = "COVER_REFUND";
        /** 备付金发放 */
        public final static String SCM_CALL_LOG_COVER_GRANT = "COVER_GRANT";
        /** 备付金领取 */
        public final static String SCM_CALL_LOG_COVER_RECEIVE = "COVER_RECEIVE";


        /** 领取验证状态 */
        public final static String RECEIVE_VALIDATE_STATUS = "RECEIVE_VALIDATE_STATUS";
        /** 领取验证状态: 已领取 */
        public final static String RECEIVE_VALIDATE_STATUS_RECEIVE = "RECEIVE";
        /** 领取验证状态: 未领取 */
        public final static String RECEIVE_VALIDATE_STATUS_UNRECEIVED = "UNRECEIVED";

        /** 发放订单支付状态 */
        public final static String SCM_PAY_STATUS = "SCM_PAY_STATUS";
        /** 发放订单支付状态: 待支付 */
        public final static String SCM_PAY_STATUS_UNPAID = "UNPAID";
        /** 发放订单支付状态: 支付中 */
        public final static String SCM_PAY_STATUS_IN_PROCESS = "IN_PROCESS";
        /** 发放订单支付状态: 成功 */
        public final static String SCM_PAY_STATUS_SUCCESS = "SUCCESS";
        /** 发放订单支付状态: 失败 */
        public final static String SCM_PAY_STATUS_FAILURE = "FAILURE";
        /** 发放订单支付状态: 退款 */
        public final static String SCM_PAY_STATUS_REFUND = "REFUND";

        /** 发放订单支付方式 */
        public final static String SCM_PAY_WAY = "SCM_PAY_WAY";
        /** 发放订单支付方式: 额度 */
        public final static String SCM_PAY_WAY_QUOTA = "QUOTA";
        /** 发放订单支付方式： 现金 */
        public final static String SCM_PAY_WAY_CASH = "CASH";
        /** 发放订单支付方式： 额度现金 */
        public final static String SCM_PAY_WAY_QC = "QC";
        /** 发放订单支付方式： 积分 */
        public final static String SCM_PAY_WAY_POINT = "POINT";

        /** 备付金扣减时点：发放时扣减 */
        public static final String DEDUCTION_ON_ISSUE = "DEDUCTION_ON_ISSUE";
        /** 备付金扣减时点：领取时扣减 */
        public static final String DEDUCTION_ON_COLLECTION = "DEDUCTION_ON_COLLECTION";

        /** 明细订单（上游订单）交易类型 */
        public static final String ORDER_DETAIL_TRADE_TYPE = "ORDER_DETAIL_TRADE_TYPE";
        /** 明细订单（上游订单）交易类型: 发放扣款*/
        public static final String ORDER_DETAIL_TRADE_TYPE_DEDUCTIONS = "DEDUCTIONS";
        /** 明细订单（上游订单）交易类型: 作废退款 */
        public static final String ORDER_DETAIL_TRADE_TYPE_REFUNDED = "REFUNDED";

        /** 主订单（下游订单）交易类型 */
        public static final String ORDER_INFOR_TRADE_TYPE = "ORDER_INFOR_TRADE_TYPE";
        /** 主订单（下游订单）交易类型: 额度扣减*/
        public static final String ORDER_INFOR_TRADE_TYPE_DEDUCTIONS = "DEDUCTIONS";
        /** 主订单（下游订单）交易类型: 额度退款 */
        public static final String ORDER_INFOR_TRADE_TYPE_REFUNDED = "REFUNDED";


        /**上下游订单的退款状态**/
        public static final String UP_ORDER_REFUNDED_STATUS="UP_ORDER_REFUNDED_STATUS";

        public static final String DOWN_ORDER_REFUNDED_STATUS="DOWN_ORDER_REFUNDED_STATUS";

        /** 已退款 */
        public static final String REFUNDED_STATUS_REFUNDED = "REFUNDED";
        /** 未退款 */
        public static final String REFUNDED_STATUS_UNREFUNDED = "UNREFUNDED";

        /**
         * 订单日志类型： 下游订单
         */
        public static final String ORDER_LOG_ORDER_TYPE_DOWN = "DOWN";
        /** 订单日志类型： 上游订单 */
        public static final String ORDER_LOG_ORDER_TYPE_UP = "UP";

        /**
         * 备付金扣减时点字典type
         */
        public static final String DEDUCTION_TIME_APPOINT="DEDUCTION_TIME_APPOINT";


        /** 上游备付金领取状态字典Type*/
        public static final String UP_ORDER_COVER_RECEIVE_STATUS="UP_ORDER_COVER_RECEIVE_STATUS";
        //成功
        public static final String UP_ORDER_COVER_RECEIVE_STATUS_SUCCESS="SUCCESS";
        //失败
        public static final String UP_ORDER_COVER_RECEIVE_STATUS_FAILURE="FAILURE";
        //未领取
        public static final String UP_ORDER_COVER_RECEIVE_STATUS_UNRECEIVED="UNRECEIVED";


        /*订单类型的字典值*/
        public final static String SCM_ORDER_TYPE="SCM_ORDER_TYPE";

        /**
         * 供应链订单类型：后台发放
         */
        public final static String SCM_ORDER_TYPE_SYS = "SYS";

        /**
         * 供应链订单类型：积分兑换
         */
        public final static String SCM_ORDER_TYPE_POINT = "POINT";

        /**
         * 供应链订单类型：赠送订单
         */
        public final static String SCM_ORDER_TYPE_GIFT = "GIFT";

        /**
         * 供应链订单类型：自购订单
         */
        public final static String SCM_ORDER_TYPE_SELF_BUY = "SELF_BUY";

        /** 备付金重新处理状态：未处理 */
        public final static String COVER_DATA_STATUS_UNPROCESSED = "UNPROCESSED";
        /** 备付金重新处理状态：已处理 */
        public final static String COVER_DATA_STATUS_PROCESSED = "PROCESSED";
        /** 备付金重新处理状态：处理中 */
        public final static String COVER_DATA_STATUS_PROCESSING = "PROCESSING";
        /** 备付金重新处理状态：处理失败 */
        public final static String COVER_DATA_STATUS_FAILURE = "FAILURE";
        /** 备付金领取重新处理操作：领取 */
        public final static String COVER_DATA_TYPE_GRANT = "GRANT";
        /** 备付金领取重新处理操作：领取 */
        public final static String COVER_DATA_TYPE_RECEIVE = "RECEIVE";
        /** 备付金领取重新处理操作：扣减 */
        public final static String COVER_DATA_TYPE_DEDUCTIONS = "DEDUCTIONS";
        /** 备付金领取重新处理操作：退款 */
        public final static String COVER_DATA_TYPE_REFUNDED = "REFUNDED";
    }

    /**
     * scm下游订单结算状态
     */
    public static class DictSettleStatus {

        //字典类型编号
        public static String TYPE_CODE = "SCM_ORDER_SETTLE_STATUS";

        //未结算
        public static String UN_SETTLE = "UN_SETTLE";

        //已结算
        public static String SETTLED = "SETTLED";

        //结算被已撤回
      public static String RECALL = "RECALL";

    }

    /**
     * 普通常量
     */
    public class General {
        /**
         * 商户停业项提示内容
         */
        public final static String MERCHANT_STORE_STOP_BUSINESS_LABEL = "停业";
        /**
         * 商户修改项提示内容
         */
        public final static String MERCHANT_STORE_OPERATE_LABEL = "编辑";
        /**
         * 商户标签:基本信息
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_BASE = "基本信息";
        /**
         * 商户标签:营业信息
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_BUSINESS = "营业信息";

        /**
         * 加油服务
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_JIAYOU = "加油服务";
        /**
         * 洗车与加气
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_WASHCAR = "洗车与加气";
        /**
         * 商户标签:行业信息
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_INDUSTRY = "行业信息";
        /**
         * 商户标签:账号信息
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_ACCOUNT = "账号信息";
        /**
         * 商户标签:结算信息
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_SETTLE = "结算信息";
        /**
         * 商户标签：标准礼包系数
         */
        public final static String MERCHANT_STORE_UPDATE_TAB_COEFFICIENT = "标准礼包系数";

        /**
         * 设置为精选评价
         */
        public final static String MERCHANTEVALUATEKPI_ADD = "ADD";
        /**
         * 取消精选评价
         */
        public final static String MERCHANTEVALUATEKPI_CANCEL = "CANCEL";
        /**
         * 删除 评价
         */
        public final static String MERCHANTEVALUATEKPI_DELETE = "DELETE";
        /**
         * 隐藏 评价
         */
        public final static String MERCHANTEVALUATEKPI_HIDE = "HIDE";
        /**
         * 显示评价
         */
        public final static String MERCHANTEVALUATEKPI_SHOW = "SHOW";

        /**
         * 投保礼类型-套餐
         */
        public final static String MERCHANGIFTTYPE_PACKAGE = "PACKAGE";
        /**
         * 投保礼类型-项目
         */
        public final static String MERCHANGIFTTYPE_PROJECT = "PROJECT";
        /**
         * 投保礼类型-商品
         */
        public final static String MERCHANGIFTTYPE_GOODS = "GOODS";
        /**
         * 投保礼类型-代金券
         */
        public final static String MERCHANGIFTTYPE_COUPON = "COUPON";


        /**
         * 投保礼数据类型-商户端
         */
        public final static String MERCHANTSOURCETYPE_MERCHANT = "MERCHANT";
        /**
         * 投保礼数据类型-车主端
         */
        public final static String MERCHANTSOURCETYPE_CAROWNER = "CAROWNER";


        /**
         * 套餐类型-商户端
         */
        public final static String MERCHANT_BUSINESS_COMBO = "BUSINESS_COMBO";
        /**
         * 套餐类型-天安
         */
        public final static String MERCHANT_TIANAN_COMBO = "TIANAN_COMBO";

        /**
         * 商户服务项目/套餐 创建来源:后台
         */
        public final static String MERCHANT_SOURCE_SYSTEM = "SYSTEM";
        /**
         * 商户服务项目/套餐 创建来源:商户端
         */
        public final static String MERCHANT_SOURCE_MERCHANT = "MERCHANT";

        /**
         * 油站标签
         */
        public final static String MERCHANT_STORE_ALL_LABEL = "OIL_ALL";
        /**
         * 油站列表标签
         */
        public final static String MERCHANT_STORE_LABEL = "OIL_TYPE";
        /**
         * 油站详情标签列表
         */
        public final static String MERCHANT_STORE_DETAIL_LABEL = "OIL_DETAIL";
        /**
         * 可洗车
         */
        public final static String MERCHANT_STORE_WASH_LABEL = "WASH";
        /**
         * 洗车标签
         */
        public final static String MERCHANT_STORE_WASHCAR_LABEL = "WASHCAR";
        /**
         * 便利店
         */
        public final static String MERCHANT_STORE_CONVENIENCE_LABEL = "CONVENIENCE";
        /**
         * 油品型号
         */
        public final static String MERCHANT_STORE_OILTYPE_LABEL = "OIL_MODEL";
        /**
         * 支付方式
         */
        public final static String MERCHANT_STORE_OIL_PAY_WAY_LABEL = "OIL_PAY_WAY";
        /** 后台管理 */
        public final static String SYY = "SYY";
        /** 分销系统后台 */
        public final static String DISTRIBUTION = "DISTRIBUTION";
    }

    /**
     * 发号键值
     */
    public class SerialNo {
        /**
         * 商户编码序列编号
         */
        public final static String MERCHANT_STORE_CODE = "MERCHANT_STORE_CODE";
        /**
         * 商户账号编码
         */
        public final static String MERCHANT_STORE_ACCOUNT_CODE = "MERCHANT_SA_CODE";
        /**
         * 专区服务项目编码
         */
        public final static String AREA_SERVICE_CODE = "AREA_SERVICE_CODE";
        /**
         * 专区服务项目结算价格编码
         */
        public final static String AREA_SERVICE_SETTLE_CODE = "AREA_SERVICE_SETTLE_CODE";
        /**
         * 商户服务项目编码
         **/
        public final static String STORE_SERVICE_CODE = "STORE_SERVICE_CODE";
        /**
         * 商品编码序列编号
         */
        public final static String MERCHANT_GOODS_CODE = "MERCHANT_GOODS_CODE";
        /**
         * 供应商编码
         */
        public final static String MERCHANT_SUPPLIER_CODE = "MERCHANT_SUPPLIER_CODE";
        /**
         * 商户投保礼订单编码
         **/
        public final static String MERCHANT_INSURANCE_GIFT_ORDER_CODE = "MERCHANT_INSURANCE_GIFT_ORDER_CODE";
        /**
         * 代理商编码
         **/
        public final static String MERCHANT_AGENT_CODE = "MERCHANT_AGENT_CODE";
        /**
         * 合作客户编码
         **/
        public final static String MERCHANT_CUSTOMER_CODE = "MERCHANT_CUSTOMER_CODE";
        /**
         * 代理商产品编码前缀
         **/
        public final static String MERCHANT_AGENT_GOODS_CODE = "MERCHANT_AGENT_GOODS_CODE";
        /**
         * 合作商户产品编码前缀
         **/
        public final static String MERCHANT_CUSTOMER_GOODS_CODE = "MERCHANT_CUSTOMER_GOODS_CODE";
        /**
         * 供应链产品订单
         */
        public final static String PRODUCT_SCM = "PRODUCT_SCM";
    }

    /**
     * Redis缓存键值
     */
    public class RedisKey {

        /**
         * 车主端推荐的商户缓存开始编码：后面 + 商户编码 作为一个 key
         */
        public final static String CAR_INDEX_STORE_START = "RECOMMEND:";

        /**
         * 加油站对应商户类型存储的商户编码
         */
        public final static String GAS_STATION_TYPE = "GS_TYPE:";
        /**
         * 加油站对应品牌存储的商户编码
         */
        public final static String GAS_STATION_BRAND = "GS_BRAND:";
        /**
         * 加油站对应的商户列表（含商户编码，经纬度）
         */
        public final static String GAS_STATION_LIST = "GS_LIST";
        /**
         * 油站坐标
         */
        public final static String GAS_GEO_STATION_LIST = "GS_GEO_LIST";

        /**
         * 全局锁,虚拟卡占用库存
         **/
        public final static String VCARD_LOCK_OCC_STOCK = "VCARD_LOCK_OCC_STOCK";

        // 兑换商品代理人信息前缀
        public final static String EXCHANGE_GOODS_AGENT = "EXCHANGE_GOODS_AGENT:";

        // 赠送商品代理人信息前缀
        public final static String GIVE_GOODS_AGENT = "GIVE_GOODS_AGENT:";

        // 优惠专区代理人信息前缀
        public final static String SPECIAL_ZONE_AGENT = "SPECIAL_ZONE_AGENT:";

        // ROCO特惠商城代理人信息前缀
        public final static String ROCO_SPECIAL_MALL_AGENT = "ROCO_SPECIAL_MALL_AGENT:";

        // 平台产品类型-电子油卡券直充
        public final static String OIL_CARD_DIGITAL_YES = "OIL_CARD_DIGITAL_YES";
        // 平台产品类型-电子油卡券非直充
        public final static String OIL_CARD_DIGITAL = "OIL_CARD_DIGITAL";
        // 平台产品类型-加油代金券
        public final static String OIL_CASH = "OIL_CASH";
        // 平台产品类型-代驾券
        public final static String DRIVING_SERVICE = "DRIVING_SERVICE";
        // 平台产品类型-第三方套餐券
        public final static String PACKAGE = "PACKAGE";
        // 平台产品类型-年审代金券
        public final static String YEAR_REVIEW_CASH = "YEAR_REVIEW_CASH";
        // 平台产品类型-服务券
        public final static String SERVICE = "SERVICE";

        // 上游券发放模式-平台发放时发放
        public final static String PLATFORM_GRANT = "PLATFORM_GRANT";
        // 上游券发放模式-用户领券时发放
        public final static String USER_COLLECT_COUPON = "USER_COLLECT_COUPON";
        // 上游券发放模式-用户核销券时发放
        public final static String USER_WRITE_OFF = "USER_WRITE_OFF";
        /** 撤回加锁 主订单号 */
        public final static String RECALL = "RECALL:";
    }


    /**
     * 商户回调接口配置
     */
    public class MerchantCallback {
        public final static String MERCHANT_STORE_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/store/storeApproveCallBlack";

        public final static String MERCHANT_GOODS_STATUS_UP_LIST_CALLBLACK_INFERFACE = "/api/merchant/goods/goodsApproveCallBlack";
    }

    /**
     * 业务流水业务中的单据类型
     */
    public class MerchantStockBusinessLogDocType {
        /**
         * 订单
         */
        public final static String ORDER = "ORDER";
    }


    /**
     * 业务系统操作人员，下单，系统主要是取消，库存管理端更新人员展示用
     */
    public class MerchantStockLogBusinessSystemOperator {

        public final static String OPERATOR_SYSTEM = "SYSTEM";
        public final static String OPERATOR_SYSTEM_LABEL = "系统";

        public final static String OPERATOR_ORDER = "ORDER";
        public final static String OPERATOR_ORDER_LABEL = "前台交易";


    }


    public class MerchantRabbit {
        /**
         * 商户中心-商品库存 exchange
         */
        public static final String MERCHANT_GOODS_STOCK_EXCHANGE = "MERCHANT_GOODS_STOCK_EXCHANGE";
        /**
         * 商户中心-商品库存还原 Queen
         */
        public static final String GOODS_STOCK_REVERT_QUEEN = "GOODS_STOCK_REVERT_QUEEN";
        /**
         * 商户中心-商品库存还原 route key
         */
        public static final String GOODS_STOCK_REVERT_ROUTE_KEY = "GOODS_STOCK_REVERT_ROUTE_KEY";
        /**
         * 商户中心-商品库存扣减 Queen
         */
        public static final String GOODS_STOCK_SUB_QUEEN = "GOODS_STOCK_SUB_QUEEN";
        /**
         * 商户中心-商品库存还原 route key
         */
        public static final String GOODS_STOCK_SUB_ROUTE_KEY = "GOODS_STOCK_SUB_ROUTE_KEY";


        public static final String SCM_EXCHANGE = "SCM_EXCHANGE";

        /**
         * 商户中心- 在roco车服生成用户券接口使用到队列
         */
        public static final String SCM_GRANT_USER_COUPON_QUEEN = "SCM_GRANT_USER_COUPON_QUEEN";
        public static final String SCM_GRANT_USER_COUPON_ROUTE_KEY = "SCM_GRANT_USER_COUPON_ROUTE_KEY";
        /**
         * 上游接口发放失败重复发起消息
         */
        public static final String SCM_REORDER_QUEEN = "SCM_REORDER_QUEEN";
        public static final String SCM_REORDER_QUEEN_ROUTE_KEY = "SCM_REORDER_QUEEN_ROUTE_KEY";
        /**
         * 更新权益中心用户券对应的第三方业务编号
         */
        public static final String SCM_RETHIRDBUSINESSCODE_QUEEN = "SCM_REHIRDBUSINESSCODE_QUEEN";
        public static final String SCM_RETHIRDBUSINESSCODE_QUEEN_ROUTE_KEY = "SCM_RETHIRDBUSINESSCODE_QUEEN_ROUTE_KEY";

        /** 用户券直接领取消息 */
        public static final String EQUITY_MQ_COMMON_EXCHANGES = "EQUITY_COMMON_EXCHANGES";
        public static final String EQUITY_MQ_ROUTKEY_QUEUE_RECEIVE_USER_COUPON = "EQUITY_RECEIVE";


        /**
         * （1）整个订单发券成功后，发送通知短信消息到mq,权益系统消费此消息
         */
        public static final String EQUITY_COMMON_EXCHANGES = "EQUITY_COMMON_EXCHANGES";
        public static final String EQUITY_USERCOUPON_SUCCESS_NOTIFY_ROUTE_KEY = "EQUITY_GRANT_COUPON_SEND_MESSAGE";


        /**
         * （2）整个订单发券成功后,发送 更新清单状态和发放数量消息到mq
         */
        public static final String EQUITY_UPDATE_USER_COUPON_APPLY_STATUS_QUEEN = "EQUITY_UPDATE_USERCOUPON_APPLY_STATUS_QUEEN";
        public static final String EQUITY_UPDATE_USER_COUPON_APPLY_STATUS_ROUTE_KEY = "EQUITY_UPDATE_USERCOUPON_APPLY_ROUTE_KEY";

        /**
         * 商户中心- 订单支付队列
         */
        public static final String SCM_ORDER_PAY_QUEEN = "SCM_ORDER_PAY_QUEEN";
        public static final String SCM_ORDER_PAY_ROUTE_KEY = "SCM_ORDER_PAY_ROUTE_KEY";

        /**
         * 商户中心- 备付金支付队列
         */
        public static final String SCM_COVER_PAY_QUEEN = "SCM_COVER_PAY_QUEEN";
        public static final String SCM_COVER_PAY_ROUTE_KEY = "SCM_COVER_PAY_ROUTE_KEY";


        /**
         * 商户中心- scm下游订单 结算结果通知队列
         */
        public static final String SCM_ORDER_SETTLE_RESULT_QUEEN = "SCM_ORDER_SETTLE_RESULT_QUEEN";
        public static final String SCM_ORDER_SETTLE_RESULT_ROUTE_KEY = "SCM_ORDER_SETTLE_RESULT_ROUTE_KEY";
    }

}
