package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 订单信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderInformation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单号,与权益系统的清单编号1对1 关联
     */
    private String orderCode;

    /**
     * 下单时间:等于发放时间
     */
    private LocalDateTime orderTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放成功时间
     */
    private LocalDateTime grantSuccessTime;

    /**
     * 发放总张数
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApplyDetail#quantity
     */
    private Integer quantity;

    /**
     * 发放成功张数（权益用户券的数量)
     */
    private Integer quantitySuccess;

    /**
     * 订单总金额/商品总面值
     */
    private BigDecimal totalPrice;

    /**
     * 发放成功金额
     */
    private BigDecimal successPrice;

    /**
     * 订单发放用户券状态:初始化为 "待发放"状态 (下游订单状态)
     * @see Constant.DictData.SCM_ORDER_STATUS_PENDING
     */
    private String orderStatus;

    /**
     * 明细订单数量
     */
    private Integer secondOrderNum;

    /**
     * 矫正执行次数
     */
    private Integer revisionRetryNum;

    /**
     * 领取验证状态
     * @see Constant.DictData#RECEIVE_VALIDATE_STATUS_UNRECEIVED
     */
    private String receiveValidateStatus;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveValidateTime;

    /**
     * 支付状态
     * @see Constant.DictData#SCM_PAY_STATUS_UNPAID
     */
    private String payStatus;

    /**
     * 额度支付金额,即：总支付额度
     */
    private BigDecimal payPrice;

    /**
     * 支付方式
     * @see Constant.DictData#SCM_PAY_WAY
     */
    private String payWay;

    /**
     * 额度支付尝试次数
     */
    private Integer payRetryNum;

    /**
     * 支付结果提示
     */
    private String payReason;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 额度领取状态，账户中领取额度是否已处理
     * 君同的额度账户中，是否成功增加已领取金额,当上游订单全部领取成功了才调用juntong额度账户，增加已领取金额
     */
    private String receiveQuotaStatus;

    /**
     * 备付金扣减时点: DEDUCTION_ON_ISSUE("发放时扣减"),  DEDUCTION_ON_COLLECTION("领取时扣减")
     * @see com.rocogz.syy.equity.entity.batchDistributionCouponApply.EquityBatchDistributionCouponApply#dedutionTimePoint
     * @see com.rocogz.syy.settlement.constant.SettlementConstant.DeductionTimeAppointDictData
     */
    private String dedutionTimePoint;

    /**
     * 备付金账户增加已发放额度状态,如果额度扣减成功了,才更新此字段
     * 如果额度扣减成功了，用来标记：备付金账户额度是否增加成功了
     * @see Constant.DictData#SCM_ORDER_STATUS_PENDING
     */
    private String coverGrantStatus;

    /**
     * 额度退款状态
     * @see Constant.DictData#REFUNDED_STATUS_UNREFUNDED
     */
    private String refundStatus;

    /**
     * 额度退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 额度退款时间
     */
    private LocalDateTime refundTime;

    /**
     * 撤回时间
     */
    private LocalDateTime recallTime;

    /**
     * 订单类型：后台发放/赠送订单/积分兑换
     * @see Constant.DictData#SCM_ORDER_TYPE_SYS
     */
    private String orderType;

    /**
     * 支付额度金额: settle系统中额度账户要扣减的额度
     */
    private BigDecimal payQuotaPrice;

    /**
     * 现金支付金额
     */
    private BigDecimal payCashPrice;

    /**
     * 扣减的备付金总额,整个下游订单要扣减的备付金总额,
     * 勾稽金额 就是该金额,收款单要结算的金额
     */
    private BigDecimal payCoverPrice;

    /**
     * 结算状态
     * @see Constant.DictSettleStatus#UN_SETTLE
     */
    private String settleStatus;

    /**
     * 完成结算时间
     */
    private LocalDateTime settleTime;

    /**
     * 结算批次号
     */
    private String settleBatchCode;

    /**
     * 本批次结算结果是否同步更新到结算系统中
     */
    private Boolean syncToSettle;


    /**
     * 本订单在某个收款单中占用的 结算的金额[页面展示使用此字段]
     */
    private transient BigDecimal settledAmount;

    /**
     * 供应链发放信息
     */
    @TableField(exist = false)
    private MerchantScmInformation scmInformation;

    /**
     * 发放的产品信息
     */
    @TableField(exist = false)
    private MerchantScmProductInformation scmProductInformation;

    /**
     * 发放目标用户信息
     */
    @TableField(exist = false)
    private MerchantScmTargetUser scmTargetUser;

    /**
     * 包含多个明细订单
     */
    @TableField(exist = false)
    private List<MerchantScmOrderDetail> orderDetails;


}
