package com.rocogz.merchant.entity.rocomall;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * ROCO商城商品修改操作日志
 * </p>
 *
 * @author yinshihao
 * @since 2020-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantRocoMallGoodsLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 兑换商品编码
     */
    private String goodsCode;

    /**
     * 操作项
     */
    private String logType;

    /**
     * 信息
     */
    private String logContent;

    /**
     * 操作人
     */
    private String logUser;

    /**
     * 操作时间
     */
    private LocalDateTime logTime;


}
