package com.rocogz.merchant.entity.scm;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 直充油卡订单信息表
 * @author djt
 * @date 2021/3/12
 */
@Data
@Accessors(chain = true)
public class MerchantScmOilCardOrderDetailInfo extends IdEntity {

    /**
     * 明细订单号
     */
    private String orderItemCode;

    /**
     * 中石化券码（大和和二运全面）
     */
    private String  couponNo;

    /**
     * 备付金金额
     */
    private BigDecimal payAmount;

    /**
     * 有效期->开始日期
     */
    private LocalDate startTime;

    /**
     * 有效期->结束日期
     */
    private LocalDate endTime;

}
