package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 明细订单
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderDetail extends IdEntity {

    private static final long serialVersionUID = 4042786962586393961L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 二级订单分组编码
     */
    private String itemGroupCode;

    /**
     * 明细订单编号
     */
    private String orderItemCode;

    /**
     * 合作客户产品编码
     */
    private String customerProductCode;

    /**
     * 合作客户产品名称
     */
    private String customerProductName;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 平台商品编码
     */
    private String productCode;

    /**
     * 平台商品名称
     */
    private String productName;

    /**
     * 产品类别
     * @see Constant.DictData#PRODUCT_TYPE_DRIVING_SERVICE
     */
    private String productType;

    /**
     * 第三方产品编码,即上游产品编号
     */
    private String thirdProductCode;

    /**
     * 上游订单重试次数
     */
    private Integer retryNum;

    /**
     * 上游订单最后重试时间
     */
    private LocalDateTime lastestRetryTime;

    /**
     * 回调地址
     */
    private String callbackUrl;

    /**
     * 上游订单订单状态:调用dingju后更新上游订单状态
     * 更新上游订单入口：在com.rocogz.syy.message.server.scm.MerchantScmOrderHandler实现类中回调更新
     *  （1）com.rocogz.syy.message.server.scm.consumer.ScmConsumer#handleReorderJms
     *  （2）com.rocogz.syy.message.server.scm.consumer.ScmConsumer#handleOrderJms
     * @see Constant.DictData#SCM_ORDER_STATUS_PENDING
     */
    private String orderStatus;

    /**
     * 第三方业务状态
     */
    private String thirdBusinessStatus;

    /**
     * 第三方业务号
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;

    /**
     * 第三方失败原因
     */
    private String thirdReason;

    /**
     * 发放张数
     */
    private Integer grantNum;

    /**
     * 用户券发放状态:
     * 待发放或已发放
     * @see Constant.DictData#SCM_USER_COUPON_GRANT_STATUS_PENDING
     */
    private String userCouponGrantStatus;

    /**
     * 用户券发放异常原因
     */
    private String userCouponGrantErrorReason;

    /**
     * 用户券发放重试次数
     */
    private Integer userCouponGrantRetryNum;

    /**
     * 产品性质:单品/供应商定制套餐/平台定制套餐
     * @see Constant.DictData#GOODS_NATURE_ITEM
     */
    private String goodsNature;

    /**
     * 订单核销状态,车主单核销后,权益基础服务发消息通知更新此核销状态
     */
    private String writeOffStatus;

    /**
     * 订单核销时间
     */
    private LocalDateTime writeOffTime;

    /**
     * 明细订单面值/金额
     */
    private BigDecimal detailPrice;

    /**
     * 本明细订单应该发放用户券张数，如果是套餐，则等于= sum(所有套餐子商品的com.rocogz.merchant.entity.goods.MerchantGoodsMeal#sum）
     */
    private Integer itemGrantNum;

    /**
     * 本明细订单发放用户券成功张数
     */
    private Integer itemGrantSuccessNum;

    /**
     * 本明细订单发放成功时间
     */
    private LocalDateTime itemGrantSuccessTime;

    /**
     * 第三方业务编号更新到权益中心状态
     */
    private String powerNoToEquityStatus;

    /**
     * 第三方业务编号更新到权益中心执行次数
     */
    private Integer powerNoToEquityNum;

    /**
     * 领取验证状态：用来标记：车主端客户是否点击了领取按钮
     */
    private String receiveValidateStatus;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveValidateTime;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 备付金扣减状态
     */
    private String coverPayStatus;

    /**
     * 备付金扣减成功时,备付金账户交易流水号
     */
    private String coverFlowCode;

    /**
     * 备付金扣减尝试次数
     */
    private Integer coverPayRetryNum;

    /**
     * 总备付金扣减金额
     */
    private BigDecimal coverPayPrice;

    /**
     * 备付金尝试扣减时间
     */
    private LocalDateTime coverPayTime;

    /**
     * 备付金领取状态：备付金账户中的领取金额是否增加成功
     */
    private String coverReceiveStatus;

    /**
     * 备付金退款状态
     */
    private String refundStatus;

    /**
     * 备付金退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 备付金退款时间
     */
    private LocalDateTime refundTime;

    /**
     * 撤回时间
     */
    private LocalDateTime recallTime;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 备付金支付金额,备付金账号需要扣减的备付金金额
     */
    private BigDecimal payQuotaPrice;

    /**
     * 现金支付金额
     */
    private BigDecimal payCashPrice;

    /**
     * 上游订单发放成功时间
     */
    private LocalDateTime thirdGrantSuccessTime;

    //=== 下面的属性用来传值

    //产品订单发放平台信息
    private transient MerchantScmInformation scmGrantInfo;

    //产品订单 目标用户表
    private transient MerchantScmTargetUser scmGrantTargetUser;

    private transient MerchantScmProductInformation scmProductInfo;

}
