package com.rocogz.merchant.entity.store;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 油站油品
 * </p>
 *
 * @author liangyongtong
 * @since 2021-01-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "merchant_store_oil_type")
public class MerchantStoreOilType extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 商户编码
     */
    private String storeCode;

    /**
     * 油品类型
     */
    private String type;

    /**
     * 型号
     */
    private String model;

    /**
     * 油枪数量
     */
    private Integer oilGunNum;

    /**
     * 国标价
     */
    private BigDecimal nationalStandardPrice;

    /**
     * 油站价
     */
    private BigDecimal oilStationPrice;

    /**
     * 活动价
     */
    private BigDecimal activePrice;


}
