package com.rocogz.merchant.entity.scm;

import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 供应商套餐明细【子表】
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderComboDetail extends IdEntity {

    private static final long serialVersionUID = -6611663976856795238L;
    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 子订单编码
     */
    private String orderItemCode;

    /**
     * 套餐明细订单号
     */
    private String comboOrderItemCode;

    /**
     * 套餐明细产品编码,即套餐下包含的子商品的产品编号
     */
    private String productCode;

    /**
     * 第三方产品编码
     */
    private String thirdProductCode;

    /**
     * 第三方券号,例如鼎聚返回鼎powerNo
     */
    private String thirdBusinessCode;

    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;

    /**
     * 平台套餐产品编码
     */
    private String comboProductCode;

    /**
     * 用户券发放状态:
     * @see Constant.DictData#SCM_USER_COUPON_GRANT_STATUS_PENDING
     */
    private String userCouponGrantStatus;

    /**
     * 用户券发放重试次数
     */
    private Integer userCouponGrantRetryNum;

    /**
     * 用户券发放异常原因
     */
    private String userCouponGrantErrorReason;

    /**
     * 订单核销状态: com.rocogz.merchant.constant.Constant.DictData#SCM_ORDER_WRITE_OFF_STATUS_WRITE_OFF
     */
    private String writeOffStatus;

    /**
     * 订单核销时间
     */
    private LocalDateTime writeOffTime;

    /**
     * 订单金额
     */
    private BigDecimal detailPrice;

    /**
     * 第三方业务编号更新到权益中心状态
     */
    private String powerNoToEquityStatus;

    /**
     * 第三方业务编号更新到权益中心执行次数
     */
    private Integer powerNoToEquityNum;

    /**
     * 订单状态
     */
    private String orderStatus;

    //=== 下面的属性用来传值

    //产品订单发放平台信息
    private transient MerchantScmInformation scmGrantInfo;

    //产品订单 目标用户表
    private transient MerchantScmTargetUser scmGrantTargetUser;

    private transient MerchantScmProductInformation scmProductInfo;

}
