package com.rocogz.merchant.dto.scm;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.dto.scm.order.TriggerWay;
import com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail;
import com.rocogz.merchant.entity.scm.MerchantScmProductInformation;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhangmin
 * 调用roco车服生成用户券接口 msgDto
 */
@Setter @Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class GrantUserCouponMsgDto {

    /**
     * 失败后是第几次尝试：第一次是调用是0
     */
    private Integer retryTimes;

    /**
     * 业务主单号
     */
    private String applyNo;

    /**
     * 业务单号/批量发券申请清单号
     *
     * @see MerchantScmInformation#businessCode
     */
    private String businessCode;

    /**
     * 明细订单号
     * @see MerchantScmOrderDetail#orderItemCode
     */
    private String orderItemCode;

    /**
     * 供应商套餐明细订单编号：三级订单编码
     * @see  MerchantScmOrderComboDetail#comboOrderItemCode
     */
    private String comboOrderItemCode;

    /**
     * 是否套餐
     */
    private Boolean isSuite;


    /**
     * 发放平台
     */
    private String grantPlatform;

    /**
     * 发放方式：BATCH-批量发放，INTERFACE-接口发放，MANUAL-手工发放
     */
    private String grantWay;

    /**
     * 面值
     */
    private BigDecimal faceValue;

    /**
     * 操作用户
     */
    private String operateUser;


    /**
     * 发放主体
     */
    private String source;

    /**
     * 小程序ID
     */
    private String miniAppid;

    /**
     * 生效日期:yyyy-MM-dd 00:00:00
     */
    private LocalDateTime effectiveDate;

    /**
     * 失效日期:yyyy-MM-dd 23:59:59
     */
    private LocalDateTime invalidDate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 发券性质：BUSINESS_VERIFY:业务验证，NORMAL:正常发券
     */
    private String nature;

    /**
     * 套餐平台产品编码
     * (1)非套餐时,该字段 传入null
     *（2）套餐时，传入 com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail#comboProductCode
     * @see MerchantScmOrderComboDetail#comboProductCode
     */
    private String comboProductCode;

    /**
     * (1)非套餐时：   传入 平台产品编码 (com.rocogz.merchant.entity.scm.MerchantScmOrderDetail#productCode)
     * (2)供应商套餐时：传入 套餐明细产品编码(com.rocogz.merchant.entity.scm.MerchantScmOrderComboDetail#productCode)
     */
    private String productCode;

    /**
     * 代理商产品编号
     */
    private String agentProductCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 发放规则编号
     */
    private String grantRuleCode;

    /**
     * 领取规则编号
     */
    private String receiveRuleCode;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放主体团队编码
     */
    private String teamCode;

    /**
     * @see MerchantScmProductInformation#productType
     */
    private String productType;

    /**
     * @see MerchantScmProductInformation#productNature
     */
    private String productNature;

    /**
     * 发放主体：代理商编号
     */
    private String agentCode;

    /**
     * 发放主体：合作客户编号
     */
    private String customerCode;
}
