package com.rocogz.merchant.entity.scm;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.merchant.constant.Constant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 订单信息
 * </p>
 *
 * @author liangyongtong
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class MerchantScmOrderInformation extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 下单时间
     */
    private LocalDateTime orderTime;

    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 发放成功时间
     */
    private LocalDateTime grantSuccessTime;

    /**
     * 发放总张数
     */
    private Integer quantity;

    /**
     * 发放成功张数（权益用户券的数量)
     */
    private Integer quantitySuccess;

    /**
     * 订单总金额/商品总面值
     */
    private BigDecimal totalPrice;

    /**
     * 发放成功金额
     */
    private BigDecimal successPrice;

    /**
     * 订单发放用户券状态:初始化为 "待发放"状态 (下游订单状态)
     * @see Constant.DictData.SCM_ORDER_STATUS_PENDING
     */
    private String orderStatus;

    /**
     * 明细订单数量
     */
    private Integer secondOrderNum;

    /**
     * 矫正执行次数
     */
    private Integer revisionRetryNum;

    /**
     * 领取验证状态
     */
    private String receiveValidateStatus;

    /**
     * 领取验证时间
     */
    private LocalDateTime receiveValidateTime;

    /**
     * 支付状态
     * @see Constant.DictData#SCM_PAY_STATUS_UNPAID
     */
    private String payStatus;

    /**
     * 支付金额
     */
    private BigDecimal payPrice;

    /**
     * 支付方式
     * @see Constant.DictData#SCM_PAY_WAY
     */
    private String payWay;

    /**
     * 支付次数
     */
    private Integer payRetryNum;

    /**
     * 支付结果提示
     */
    private String payReason;

    /**
     * 支付时间
     */
    private LocalDateTime payTime;

    /**
     * 领取额度状态，账户中领取额度是否已处理
     */
    private String receiveQuotaStatus;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 备付金发放状态
     */
    private String coverGrantStatus;

    /**
     * 额度退款状态
     */
    private String refundStatus;

    /**
     * 额度退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 额度退款时间
     */
    private LocalDateTime refundTime;

    /**
     * 撤回时间
     */
    private LocalDateTime recallTime;

    /**
     * 供应链发放信息
     */
    @TableField(exist = false)
    private MerchantScmInformation scmInformation;

    /**
     * 发放的产品信息
     */
    @TableField(exist = false)
    private MerchantScmProductInformation scmProductInformation;

    /**
     * 发放目标用户信息
     */
    @TableField(exist = false)
    private MerchantScmTargetUser scmTargetUser;

    /**
     * 包含多个明细订单
     */
    @TableField(exist = false)
    private List<MerchantScmOrderDetail> orderDetails;


}
