package com.rocogz.merchant.response.customer.goods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.merchant.entity.customer.goods.MerchantCustomerGoods;
import lombok.Data;

import java.math.BigDecimal;

/**
 *代理商产品列表实体类
 * @author djt
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MerchantCustomerGoodsListResp extends MerchantCustomerGoods {

    /**
     * 代理商产品状态
     */
    private String agentGoodsStatus;

    /**
     * 合作客户名称
     */
    private String customerName;


    /**
     * 代理商产品名称
     */
    private String agentGoodsName;

    /**
     *代理商简称
     */
    private String agentName;


    /**
     *列表图:路径可能会被分割成几个对应比列的图
     */
    private String listView;

    /**
     * 平台产品商品编号
     */
    private String merchantGoodsCode;


    /**
     * 平台产品商品名称
     */
    private String merchantGoodsName;

    /**
     * 平台产品商品简称
     */
    private String merchantGoodsAbbreviation;

    /**
     * 产品类型编码
     */
    private String goodsClassificationCode;

    /**
     * 产品类型编码
     */
    private String goodsClassificationName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 供应商编码
     */
    private String supplierCode;


    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 品牌名称
     */
    private String brandCode;

    /**
     * 代理商产品类型
     */
    private String goodsType;

    /**
     * 平台产品市场价
     */
    private String merchantGoodsMarketPrice;

    /**
     * 平台产品成本价
     */
    private BigDecimal costPrice;

    /**
     * 代理商采购价
     */
    private BigDecimal purchasePrice;

    /**
     * 平台商品状态
     */
    private String goodsStatus;

    /**
     * 代理商产品市场价
     */
    private String agentGoodsMarketPrice;

    /**
     * 供应商产品编号
     */
    private String supplierGoodsCode;

    /**
     * 供应商产品名称
     */
    private String supplierGoodsName;

    /**
     * 产品类型
     */
    private String productTypeName;


    /**
     * 产品内容
     */
    private String goodsContent;


}
