package com.rocogz.merchant.dto.scm;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/3/12 17:01</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
public class UpOrderQueryResultDto {
    /**
     * 上游订单编号
     */
    private String orderItemCode;
    /**
     * 下游订单编号
     */
    private String orderCode;
    /**
     * 合作客户产品编号
     */
    private String customerProductCode;
    /**
     * 合作客户产品名称
     */
    private String customerProductName;
    /**
     * 代理商产品编号
     */
    private String agentProductCode;
    /**
     * 代理商产品名称
     */
    private String agentProductName ;
    /**
     * 平台产品编号
     */
    private String productCode;
    /**
     * 平台产品名称
     */
    private String productName;
    /**
     * 产品类别
     */
    private String productCategoryCode;
    /**
     * 产品类型
     */
    private String productTypeCode;
    /**
     * 产品类型
     */
    private String productTypeName;
    /**
     * 产品性质
     */
    private String goodsNature;
    /**
     * 第三方产品编码
     */
    private String thirdProductCode;
    /**
     * 发放会员手机号
     */
    private String grantMobile;
    /**
     * 发放会员证件类型
     */
    private String grantIdtype;
    /**
     * 发放会员证件信息
     */
    private String grantIdno;
    /**
     * 发放会员车牌号
     */
    private String grantLicence;
    /**
     * 发放会员姓名
     */
    private String grantUsername;
    /**
     * 发放会员保单号
     */
    private String policyNumber;
    /**
     * 真实会员手机号
     */
    private String realMobile;
    /**
     * 第三方业务状态
     */
    private String thirdBusinessStatus;
    /**
     * 第三方业务号
     */
    private String thirdBusinessCode;
    /**
     * ROCO车服用户券号
     */
    private String rocoUserCouponCode;
    /**
     * 发放张数
     */
    private Integer grantNum;
    /**
     * 订单价格
     */
    private BigDecimal detailPrice;
    /**
     * 下单时间
     */
    private LocalDateTime orderTime;
    /**
     * 发放时间
     */
    private LocalDateTime grantTime;

    /**
     * 第三方发放成功时间，上游订单状态是已发放的时间
     */
    private LocalDateTime thirdGrantSuccessTime;

    /**
     * 订单核销状态
     */
    private String writeOffStatus;
    /**
     * 下游订单状态
     */
    private String orderStatus;
    /**
     * 上游订单状态
     */
    private String orderItemStatus;

    private String productCategoryName;
    private String goodsNatureName;
    private String grantIdtypeName;
    private String writeOffStatusName;
    private String orderStatusName;
    private String orderItemStatusName;

    /**
     * 发券性质
     */
    private String grantNature;
    /**
     * 发券性质名字
     */
    private String grantNatureName;
    /**
     * 领取验证时间
     */
    private LocalDateTime receiveValidateTime;
    /**
     * 领取验证状态
     */
    private String receiveValidateStatus;
    /**
     * 领取状态名字
     */
    private String receiveValidateStatusName;

    /** 下面的字段明细里会用到 */
    /**
     * 第三方业务编号更新到权益中心状态
     */
    private String powerNoToEquityStatus;

    /**
     * 第三方业务编号更新到权益中心执行次数
     */
    private Integer powerNoToEquityNum;

    private String powerNoToEquityStatusName;
    private String userCouponGrantStatus;
    private String userCouponGrantStatusName;
    private String userCouponGrantRetryNum;
    private String retryNum;
    private LocalDateTime lastestRetryTime;
    private String callbackUrl;
    private BigDecimal customerPurchasePrice;
    private BigDecimal customerMarketPrice;
    private BigDecimal agentPurchasePrice;
    private BigDecimal agentMarketPrice;
    private BigDecimal purchasePrice;
    private BigDecimal marketPrice;
    private String couponCode;


    /**
     * 主体的性质
     */
    private String sourceNature;

    /**
     * 合作客户专享价合计
     */
    private String customerPurchasePriceTotal;
    /**
     * 合作客户产品市场价/面额合计
     */
    private String customerMarketPriceTotal;
    /**
     * 代理商采购价合计
     */
    private String agentPurchasePriceTotal;

    /**
     * 代理商产品市场价/面额合计
     */
    private String agentMarketPriceTotal;

    /**
     * 平台采购价合计
     */
    private String purchasePriceTotal;

    /**
     * 平台市场价/面额合计
     */
    private String marketPriceTotal;



    /**
     * 发放主体
     */

    private String sourceCode;

    /**
     * 发放主体名称，在聚合中查询一次
     */
    private String sourceName;

    /**
     * 发放客户
     */

    private String sourceCustomer;
    /**
     * 发放客户名称
     */
    private String sourceCustomerName;

    /**
     * 发放方式
     */

    private String grantWay;
    /**
     * 发放方式名称
     */
    private String grantWayName;

    /**
     * 发放平台来源
     */

    private String grantPlatform;

    /**
     * 发放平台来源名称
     */
    private String grantPlatformName;

    /**
     * 发放目标平台
     */

    private String targetPlatform;

    /**
     * 发放目标平台名称
     */
    private String targetPlatformName;

    /**
     * 发放目标平台小程序ID
     */
    private String targetMiniAppid;

    /**
     * 发放目标平台小程序Name
     */
    private String targetMiniAppidName;

    /**
     * 下单业务号
     */
    private String businessCode;

    //todo

    /**
     * 备付金扣减时点和下游订单的一样的
     */
    private String dedutionTimePoint;

    /**
     * 备付金扣减时点名字
     */
    private String dedutionTimePointName;

    /**
     * 备付金扣减状态
     */
    private String coverPayStatus;
    /**
     * 备付金扣减状态名称
     */
    private String coverPayStatusName;
    /**
     * 支付流水号
     */
    private String coverFlowCode;
    /**
     * 备付金扣减次数
     */
    private Integer coverPayRetryNum;
    /**
     * 备付金扣减金额
     */
    private BigDecimal coverPayPrice;
    /**
     * 备付金支付时间
     */
    private LocalDateTime coverPayTime;
    /**
     * 备付金领取状态
     */
    private String coverReceiveStatus;
    /**
     * 备付金领取状态名称
     */
    private String coverReceiveStatusName;

    /**
     * 备付金退款状态
     */
    private String coverRefundStatus;

    /**
     * 备付金退款状态名字
     */
    private String coverRefundStatusName;

    /**
     * 备付金退款金额
     */
    private BigDecimal coverRefundPrice;

    /**
     * 备付金退款时间开始
     */
    private LocalDateTime coverRefundTime;

    /**
     * 备付金撤回时间开始
     */
    private LocalDateTime coverRecallTime;

    /**
     * 备付金支付金额
     */
    private BigDecimal payQuotaPrice;

    /**
     * 现金支付金额
     */
    private BigDecimal payCashPrice;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 订单类型名称
     */
    private String orderTypeName;


    /**
     * 合作客户结算采购价
     */
    private BigDecimal customerPurchaseSettlePrice;

    /**
     * 代理商结算采购价
     */
    private BigDecimal agentPurchaseSettlePrice;

    /**
     * 平台产品采购价合计
     */
    private String customerPurchaseSettlePriceTotal;

    /**
     * 代理商结算采购价合计
     */
    private String agentPurchaseSettlePriceTotal;

    /**
     * 车架号
     */
    private String vinNo;


}
