package com.rocogz.merchant.request.customer.goods;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 * @date 2021/2/3
 */
@Data
@Accessors(chain = true)
public class MerchantCustomerGoodsSearchReq implements Serializable {

    /**
     * 合作客户编号
     */
    private String customerCode;


    /**
     * 合作客户编号列表
     */
    private List<String> customerCodeList;

    /**
     * 合作客户产品编号
     */
    private String code;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 采购方式
     */
    private String purchaseWay;

    /**
     * 产品类型
     */
    private String goodCategory;

    /**
     * 代理商产品编号
     */
    private String agentGoodsCode;

    /**
     * 平台产品编号
     */
    private String merchantGoodsCode;

    /**
     * 代理产品编号
     */
    private String supplierProductCode;

    /**
     * 产品状态
     */
    private String status;

    /**
     * 排序字段
     */
    private String sortProp;

    /**
     * 排序方式
     */
    private String sortType;

    /**
     * 页大小
     */
    private Integer limit=10 ;

    /**
     * 当前页
     */
    private Integer page=1 ;

}
