package com.rocogz.merchant.dto.scm;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 订单支付信息
 * @author：liangyongtong
 * @since：2021/4/8
 */
@Data
@Accessors(chain = true)
public class ScmOrderPayDto implements Serializable {

    private Integer id;

    /**
     * 发放客户
     */
    private String sourceCustomer;

    /**
     * 捐款账户
     */
    private String dedutionCustomerCode;

    /**
     * 服务商备付金扣款账号
     */
    private String deductionAgentCode;

    /**
     * 订单编码
     */
    private String orderCode;

    /**
     * 申请人
     */
    private String personCode;

    /**
     * 业务清单编号
     */
    private String businessCode;

    /**
     * 金额
     */
    private BigDecimal payPrice;

    /**
     * 支付次数
     */
    private int payRetryNum;

    /**
     * 备付金扣减时点
     */
    private String dedutionTimePoint;

    /**
     * 额度账户 额度是否已领取
     */
    private String receiveQuotaStatus;

    /**
     * 服务商备付金支付状态
     */
    private String agentPayStatus;

    /**
     * 服务商备付金支付金额
     */
    private BigDecimal agentPayPrice;

    /**
     * 服务商备付金退款状态
     */
    private String agentRefundStatus;

    /**
     * 服务商备付金扣减时点
     */
    private String agentDeductionTime;

    /**
     * 服务商备付金支付状态
     */
    private String customerPayStatus;

    /**
     * 服务商备付金支付金额
     */
    private BigDecimal customerPayPrice;

    /**
     * 服务商备付金退款状态
     */
    private String customerRefundStatus;

}
